/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureAppender;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStepFactory;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.AbstractLinkFeatureAppenderFactory;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.SinglePropertyFeatureAppender;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.UnionLinkFeatureAppender;

public class L2FeatureStep
implements LinkFeatureStep {
    private final List<String> nodeProperties;

    public L2FeatureStep(List<String> nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    @Override
    public LinkFeatureAppender linkFeatureAppender(Graph graph) {
        LinkFeatureAppender[] appenderPerProperty = new L2LinkFeatureAppenderFactory().createAppenders(graph, this.nodeProperties);
        return new UnionLinkFeatureAppender(appenderPerProperty, this.name(), this.nodeProperties);
    }

    @Override
    public List<String> inputNodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public Map<String, Object> configuration() {
        return Map.of("nodeProperties", this.nodeProperties);
    }

    @Override
    public String name() {
        return LinkFeatureStepFactory.L2.name();
    }

    private static class L2LinkFeatureAppenderFactory
    extends AbstractLinkFeatureAppenderFactory {
        private L2LinkFeatureAppenderFactory() {
        }

        @Override
        protected LinkFeatureAppender doubleArrayAppender(NodePropertyValues props, int dimension) {
            return new L2DoubleArrayFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender floatArrayAppender(NodePropertyValues props, int dimension) {
            return new L2FloatArrayFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender longArrayAppender(NodePropertyValues props, int dimension) {
            return new L2LongArrayFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender longAppender(NodePropertyValues props, int dimension) {
            return new L2LongFeatureAppender(props, dimension);
        }

        @Override
        protected LinkFeatureAppender doubleAppender(NodePropertyValues props, int dimension) {
            return new L2DoubleFeatureAppender(props, dimension);
        }

        private static class L2LongFeatureAppender
        extends SinglePropertyFeatureAppender {
            L2LongFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                linkFeatures[offset] = Math.pow(this.props.longValue(source) - this.props.longValue(target), 2.0);
            }
        }

        private static class L2DoubleFeatureAppender
        extends SinglePropertyFeatureAppender {
            L2DoubleFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                linkFeatures[offset] = Math.pow(this.props.doubleValue(source) - this.props.doubleValue(target), 2.0);
            }
        }

        private static class L2LongArrayFeatureAppender
        extends SinglePropertyFeatureAppender {
            L2LongArrayFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                long[] sourceArrayPropValues = this.props.longArrayValue(source);
                long[] targetArrayPropValues = this.props.longArrayValue(target);
                assert (sourceArrayPropValues.length == targetArrayPropValues.length);
                for (int i = 0; i < sourceArrayPropValues.length; ++i) {
                    linkFeatures[offset++] = Math.pow(sourceArrayPropValues[i] - targetArrayPropValues[i], 2.0);
                }
            }
        }

        private static class L2FloatArrayFeatureAppender
        extends SinglePropertyFeatureAppender {
            L2FloatArrayFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                float[] sourceArrayPropValues = this.props.floatArrayValue(source);
                float[] targetArrayPropValues = this.props.floatArrayValue(target);
                assert (sourceArrayPropValues.length == targetArrayPropValues.length);
                for (int i = 0; i < sourceArrayPropValues.length; ++i) {
                    linkFeatures[offset++] = Math.pow(sourceArrayPropValues[i] - targetArrayPropValues[i], 2.0);
                }
            }
        }

        private static class L2DoubleArrayFeatureAppender
        extends SinglePropertyFeatureAppender {
            L2DoubleArrayFeatureAppender(NodePropertyValues props, int dimension) {
                super(props, dimension);
            }

            @Override
            public void appendFeatures(long source, long target, double[] linkFeatures, int offset) {
                double[] sourceArrayPropValues = this.props.doubleArrayValue(source);
                double[] targetArrayPropValues = this.props.doubleArrayValue(target);
                assert (sourceArrayPropValues.length == targetArrayPropValues.length);
                for (int i = 0; i < sourceArrayPropValues.length; ++i) {
                    linkFeatures[offset++] = Math.pow(sourceArrayPropValues[i] - targetArrayPropValues[i], 2.0);
                }
            }
        }
    }
}

