/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainResult;
import org.neo4j.gds.ml.training.TrainingStatistics;

@ParametersAreNonnullByDefault
@Generated(from="LinkPredictionTrainResult", generator="Immutables")
@Immutable
public final class ImmutableLinkPredictionTrainResult
implements LinkPredictionTrainResult {
    private final Classifier classifier;
    private final TrainingStatistics trainingStatistics;

    private ImmutableLinkPredictionTrainResult(Classifier classifier, TrainingStatistics trainingStatistics) {
        this.classifier = Objects.requireNonNull(classifier, "classifier");
        this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
    }

    private ImmutableLinkPredictionTrainResult(ImmutableLinkPredictionTrainResult original, Classifier classifier, TrainingStatistics trainingStatistics) {
        this.classifier = classifier;
        this.trainingStatistics = trainingStatistics;
    }

    @Override
    public Classifier classifier() {
        return this.classifier;
    }

    @Override
    public TrainingStatistics trainingStatistics() {
        return this.trainingStatistics;
    }

    public final ImmutableLinkPredictionTrainResult withClassifier(Classifier value) {
        if (this.classifier == value) {
            return this;
        }
        Classifier newValue = Objects.requireNonNull(value, "classifier");
        return new ImmutableLinkPredictionTrainResult(this, newValue, this.trainingStatistics);
    }

    public final ImmutableLinkPredictionTrainResult withTrainingStatistics(TrainingStatistics value) {
        if (this.trainingStatistics == value) {
            return this;
        }
        TrainingStatistics newValue = Objects.requireNonNull(value, "trainingStatistics");
        return new ImmutableLinkPredictionTrainResult(this, this.classifier, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionTrainResult && this.equalTo((ImmutableLinkPredictionTrainResult)another);
    }

    private boolean equalTo(ImmutableLinkPredictionTrainResult another) {
        return this.classifier.equals(another.classifier) && this.trainingStatistics.equals(another.trainingStatistics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.classifier.hashCode();
        h += (h << 5) + this.trainingStatistics.hashCode();
        return h;
    }

    public String toString() {
        return "LinkPredictionTrainResult{classifier=" + this.classifier + ", trainingStatistics=" + this.trainingStatistics + "}";
    }

    public static LinkPredictionTrainResult of(Classifier classifier, TrainingStatistics trainingStatistics) {
        return new ImmutableLinkPredictionTrainResult(classifier, trainingStatistics);
    }

    public static LinkPredictionTrainResult copyOf(LinkPredictionTrainResult instance) {
        if (instance instanceof ImmutableLinkPredictionTrainResult) {
            return (ImmutableLinkPredictionTrainResult)instance;
        }
        return ImmutableLinkPredictionTrainResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LinkPredictionTrainResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLASSIFIER = 1L;
        private static final long INIT_BIT_TRAINING_STATISTICS = 2L;
        private long initBits = 3L;
        @Nullable
        private Classifier classifier;
        @Nullable
        private TrainingStatistics trainingStatistics;

        private Builder() {
        }

        public final Builder from(LinkPredictionTrainResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.classifier(instance.classifier());
            this.trainingStatistics(instance.trainingStatistics());
            return this;
        }

        public final Builder classifier(Classifier classifier) {
            this.classifier = Objects.requireNonNull(classifier, "classifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder trainingStatistics(TrainingStatistics trainingStatistics) {
            this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.classifier = null;
            this.trainingStatistics = null;
            return this;
        }

        public LinkPredictionTrainResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkPredictionTrainResult(null, this.classifier, this.trainingStatistics);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("classifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("trainingStatistics");
            }
            return "Cannot build LinkPredictionTrainResult, some of required attributes are not set " + attributes;
        }
    }
}

