/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.train;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.ml.metrics.Metric;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.model.ModelConfig;

public final class LinkPredictionTrainConfigImpl
implements LinkPredictionTrainConfig {
    private double negativeClassWeight;
    private String pipeline;
    private String targetRelationshipType;
    private String sourceNodeLabel;
    private String targetNodeLabel;
    private List<Metric> metrics;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private String graphName;
    private String modelName;
    private String modelUser;
    private Optional<Long> randomSeed;

    public LinkPredictionTrainConfigImpl(@NotNull String modelUser, @NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.negativeClassWeight = config.getDouble("negativeClassWeight", LinkPredictionTrainConfig.super.negativeClassWeight());
            CypherMapAccess.validateDoubleRange((String)"negativeClassWeight", (double)this.negativeClassWeight, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.pipeline = (String)CypherMapAccess.failOnNull((String)"pipeline", (Object)config.requireString("pipeline"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetRelationshipType = (String)CypherMapAccess.failOnNull((String)"targetRelationshipType", (Object)config.requireString("targetRelationshipType"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNodeLabel = (String)CypherMapAccess.failOnNull((String)"sourceNodeLabel", (Object)config.getString("sourceNodeLabel", LinkPredictionTrainConfig.super.sourceNodeLabel()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodeLabel = (String)CypherMapAccess.failOnNull((String)"targetNodeLabel", (Object)config.getString("targetNodeLabel", LinkPredictionTrainConfig.super.targetNodeLabel()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.metrics = (List)CypherMapAccess.failOnNull((String)"metrics", LinkPredictionTrainConfig.namesToMetrics((List)config.getChecked("metrics", LinkPredictionTrainConfig.super.metrics(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", LinkPredictionTrainConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", LinkPredictionTrainConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", LinkPredictionTrainConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)LinkPredictionTrainConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = (String)CypherMapAccess.failOnNull((String)"graphName", (Object)config.requireString("graphName"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapAccess.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelUser = (String)CypherMapAccess.failOnNull((String)"modelUser", (Object)modelUser);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double negativeClassWeight() {
        return this.negativeClassWeight;
    }

    @Override
    public String pipeline() {
        return this.pipeline;
    }

    @Override
    public String targetRelationshipType() {
        return this.targetRelationshipType;
    }

    @Override
    public String sourceNodeLabel() {
        return this.sourceNodeLabel;
    }

    @Override
    public String targetNodeLabel() {
        return this.targetNodeLabel;
    }

    @Override
    public List<Metric> metrics() {
        return this.metrics;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateSourceNodeLabel(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateTargetNodeLabel(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateTargetRelIsUndirected(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("negativeClassWeight", "pipeline", "targetRelationshipType", "sourceNodeLabel", "targetNodeLabel", "metrics", "username", "sudo", "logProgress", "concurrency", "jobId", "graphName", "modelName", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("negativeClassWeight", this.negativeClassWeight());
        map.put("pipeline", this.pipeline());
        map.put("targetRelationshipType", this.targetRelationshipType());
        map.put("sourceNodeLabel", this.sourceNodeLabel());
        map.put("targetNodeLabel", this.targetNodeLabel());
        map.put("metrics", LinkPredictionTrainConfig.metricsToNames(this.metrics()));
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("graphName", this.graphName());
        map.put("modelName", this.modelName());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public String graphName() {
        return this.graphName;
    }

    public String modelName() {
        return this.modelName;
    }

    public String modelUser() {
        return this.modelUser;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String modelUser;

        public static Builder from(LinkPredictionTrainConfig baseConfig) {
            Builder builder = new Builder();
            builder.negativeClassWeight(baseConfig.negativeClassWeight());
            builder.pipeline(baseConfig.pipeline());
            builder.targetRelationshipType(baseConfig.targetRelationshipType());
            builder.sourceNodeLabel(baseConfig.sourceNodeLabel());
            builder.targetNodeLabel(baseConfig.targetNodeLabel());
            builder.metrics(baseConfig.metrics());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.graphName(baseConfig.graphName());
            builder.modelName(baseConfig.modelName());
            builder.modelUser(baseConfig.modelUser());
            builder.randomSeed(baseConfig.randomSeed());
            return builder;
        }

        public Builder modelUser(String modelUser) {
            this.modelUser = modelUser;
            return this;
        }

        public Builder negativeClassWeight(double negativeClassWeight) {
            this.config.put("negativeClassWeight", negativeClassWeight);
            return this;
        }

        public Builder pipeline(String pipeline) {
            this.config.put("pipeline", pipeline);
            return this;
        }

        public Builder targetRelationshipType(String targetRelationshipType) {
            this.config.put("targetRelationshipType", targetRelationshipType);
            return this;
        }

        public Builder sourceNodeLabel(String sourceNodeLabel) {
            this.config.put("sourceNodeLabel", sourceNodeLabel);
            return this;
        }

        public Builder targetNodeLabel(String targetNodeLabel) {
            this.config.put("targetNodeLabel", targetNodeLabel);
            return this;
        }

        public Builder metrics(List<?> metrics) {
            this.config.put("metrics", metrics);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder graphName(String graphName) {
            this.config.put("graphName", graphName);
            return this;
        }

        public Builder modelName(String modelName) {
            this.config.put("modelName", modelName);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public LinkPredictionTrainConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new LinkPredictionTrainConfigImpl(this.modelUser, (CypherMapAccess)config);
        }
    }
}

