/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPredictionSplitConfig;

public final class NodePropertyPredictionSplitConfigImpl
implements NodePropertyPredictionSplitConfig {
    private double testFraction;
    private int validationFolds;

    public NodePropertyPredictionSplitConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.testFraction = config.getDouble("testFraction", NodePropertyPredictionSplitConfig.super.testFraction());
            CypherMapAccess.validateDoubleRange((String)"testFraction", (double)this.testFraction, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validationFolds = config.getInt("validationFolds", NodePropertyPredictionSplitConfig.super.validationFolds());
            CypherMapAccess.validateIntegerRange((String)"validationFolds", (int)this.validationFolds, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double testFraction() {
        return this.testFraction;
    }

    @Override
    public int validationFolds() {
        return this.validationFolds;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("testFraction", this.testFraction());
        map.put("validationFolds", this.validationFolds());
        return map;
    }

    @Override
    public Collection<String> configKeys() {
        return Arrays.asList("testFraction", "validationFolds");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(NodePropertyPredictionSplitConfig baseConfig) {
            Builder builder = new Builder();
            builder.testFraction(baseConfig.testFraction());
            builder.validationFolds(baseConfig.validationFolds());
            return builder;
        }

        public Builder testFraction(double testFraction) {
            this.config.put("testFraction", testFraction);
            return this;
        }

        public Builder validationFolds(int validationFolds) {
            this.config.put("validationFolds", validationFolds);
            return this;
        }

        public NodePropertyPredictionSplitConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new NodePropertyPredictionSplitConfigImpl((CypherMapAccess)config);
        }
    }
}

