/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.classification.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.collections.LongMultiSet;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.LabelsAndClassCountsExtractor;

@ParametersAreNonnullByDefault
@Generated(from="LabelsAndClassCountsExtractor.LabelsAndClassCounts", generator="Immutables")
@Immutable
public final class ImmutableLabelsAndClassCounts
implements LabelsAndClassCountsExtractor.LabelsAndClassCounts {
    private final HugeIntArray labels;
    private final LongMultiSet classCounts;

    private ImmutableLabelsAndClassCounts(HugeIntArray labels, LongMultiSet classCounts) {
        this.labels = Objects.requireNonNull(labels, "labels");
        this.classCounts = Objects.requireNonNull(classCounts, "classCounts");
    }

    private ImmutableLabelsAndClassCounts(ImmutableLabelsAndClassCounts original, HugeIntArray labels, LongMultiSet classCounts) {
        this.labels = labels;
        this.classCounts = classCounts;
    }

    @Override
    public HugeIntArray labels() {
        return this.labels;
    }

    @Override
    public LongMultiSet classCounts() {
        return this.classCounts;
    }

    public final ImmutableLabelsAndClassCounts withLabels(HugeIntArray value) {
        if (this.labels == value) {
            return this;
        }
        HugeIntArray newValue = Objects.requireNonNull(value, "labels");
        return new ImmutableLabelsAndClassCounts(this, newValue, this.classCounts);
    }

    public final ImmutableLabelsAndClassCounts withClassCounts(LongMultiSet value) {
        if (this.classCounts == value) {
            return this;
        }
        LongMultiSet newValue = Objects.requireNonNull(value, "classCounts");
        return new ImmutableLabelsAndClassCounts(this, this.labels, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLabelsAndClassCounts && this.equalTo((ImmutableLabelsAndClassCounts)another);
    }

    private boolean equalTo(ImmutableLabelsAndClassCounts another) {
        return this.labels.equals(another.labels) && this.classCounts.equals(another.classCounts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.classCounts.hashCode();
        return h;
    }

    public String toString() {
        return "LabelsAndClassCounts{labels=" + this.labels + ", classCounts=" + this.classCounts + "}";
    }

    public static LabelsAndClassCountsExtractor.LabelsAndClassCounts of(HugeIntArray labels, LongMultiSet classCounts) {
        return new ImmutableLabelsAndClassCounts(labels, classCounts);
    }

    static LabelsAndClassCountsExtractor.LabelsAndClassCounts copyOf(LabelsAndClassCountsExtractor.LabelsAndClassCounts instance) {
        if (instance instanceof ImmutableLabelsAndClassCounts) {
            return (ImmutableLabelsAndClassCounts)instance;
        }
        return ImmutableLabelsAndClassCounts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LabelsAndClassCountsExtractor.LabelsAndClassCounts", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_LABELS = 1L;
        private static final long INIT_BIT_CLASS_COUNTS = 2L;
        private long initBits = 3L;
        @Nullable
        private HugeIntArray labels;
        @Nullable
        private LongMultiSet classCounts;

        private Builder() {
        }

        public final Builder from(ImmutableLabelsAndClassCounts instance) {
            return this.from((LabelsAndClassCountsExtractor.LabelsAndClassCounts)instance);
        }

        final Builder from(LabelsAndClassCountsExtractor.LabelsAndClassCounts instance) {
            Objects.requireNonNull(instance, "instance");
            this.labels(instance.labels());
            this.classCounts(instance.classCounts());
            return this;
        }

        public final Builder labels(HugeIntArray labels) {
            this.labels = Objects.requireNonNull(labels, "labels");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder classCounts(LongMultiSet classCounts) {
            this.classCounts = Objects.requireNonNull(classCounts, "classCounts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.labels = null;
            this.classCounts = null;
            return this;
        }

        public LabelsAndClassCountsExtractor.LabelsAndClassCounts build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLabelsAndClassCounts(null, this.labels, this.classCounts);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("labels");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("classCounts");
            }
            return "Cannot build LabelsAndClassCounts, some of required attributes are not set " + attributes;
        }
    }
}

