/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.classification.train;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.TrainerConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPredictPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.NodeClassificationPipelineModelInfo;

@ParametersAreNonnullByDefault
@Generated(from="NodeClassificationPipelineModelInfo", generator="Immutables")
@Immutable
public final class ImmutableNodeClassificationPipelineModelInfo
implements NodeClassificationPipelineModelInfo {
    private final TrainerConfig bestParameters;
    private final Map<String, Object> metrics;
    private final NodePropertyPredictPipeline pipeline;
    private final List<Long> classes;
    private final transient Map<String, Object> toMap;

    private ImmutableNodeClassificationPipelineModelInfo(TrainerConfig bestParameters, Map<String, ? extends Object> metrics, NodePropertyPredictPipeline pipeline, Iterable<Long> classes) {
        this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
        this.metrics = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableMap(true, false, metrics);
        this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
        this.classes = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(false, ImmutableNodeClassificationPipelineModelInfo.createSafeList(classes, true, false));
        this.toMap = Objects.requireNonNull(NodeClassificationPipelineModelInfo.super.toMap(), "toMap");
    }

    private ImmutableNodeClassificationPipelineModelInfo(ImmutableNodeClassificationPipelineModelInfo original, TrainerConfig bestParameters, Map<String, Object> metrics, NodePropertyPredictPipeline pipeline, List<Long> classes) {
        this.bestParameters = bestParameters;
        this.metrics = metrics;
        this.pipeline = pipeline;
        this.classes = classes;
        this.toMap = Objects.requireNonNull(NodeClassificationPipelineModelInfo.super.toMap(), "toMap");
    }

    @Override
    public TrainerConfig bestParameters() {
        return this.bestParameters;
    }

    @Override
    public Map<String, Object> metrics() {
        return this.metrics;
    }

    @Override
    public NodePropertyPredictPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public List<Long> classes() {
        return this.classes;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableNodeClassificationPipelineModelInfo withBestParameters(TrainerConfig value) {
        if (this.bestParameters == value) {
            return this;
        }
        TrainerConfig newValue = Objects.requireNonNull(value, "bestParameters");
        return new ImmutableNodeClassificationPipelineModelInfo(this, newValue, this.metrics, this.pipeline, this.classes);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withMetrics(Map<String, ? extends Object> entries) {
        if (this.metrics == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.bestParameters, newValue, this.pipeline, this.classes);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withPipeline(NodePropertyPredictPipeline value) {
        if (this.pipeline == value) {
            return this;
        }
        NodePropertyPredictPipeline newValue = Objects.requireNonNull(value, "pipeline");
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.bestParameters, this.metrics, newValue, this.classes);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withClasses(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(false, wrappedList);
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.bestParameters, this.metrics, this.pipeline, newValue);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withClasses(Iterable<Long> elements) {
        if (this.classes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(false, ImmutableNodeClassificationPipelineModelInfo.createSafeList(elements, true, false));
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.bestParameters, this.metrics, this.pipeline, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationPipelineModelInfo && this.equalTo((ImmutableNodeClassificationPipelineModelInfo)another);
    }

    private boolean equalTo(ImmutableNodeClassificationPipelineModelInfo another) {
        return this.bestParameters.equals(another.bestParameters) && this.metrics.equals(another.metrics) && this.pipeline.equals(another.pipeline) && this.classes.equals(another.classes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bestParameters.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        h += (h << 5) + this.pipeline.hashCode();
        h += (h << 5) + this.classes.hashCode();
        return h;
    }

    public String toString() {
        return "NodeClassificationPipelineModelInfo{bestParameters=" + this.bestParameters + ", metrics=" + this.metrics + ", pipeline=" + this.pipeline + ", classes=" + this.classes + "}";
    }

    public static NodeClassificationPipelineModelInfo of(TrainerConfig bestParameters, Map<String, Object> metrics, NodePropertyPredictPipeline pipeline, List<Long> classes) {
        return ImmutableNodeClassificationPipelineModelInfo.of(bestParameters, metrics, pipeline, classes);
    }

    public static NodeClassificationPipelineModelInfo of(TrainerConfig bestParameters, Map<String, ? extends Object> metrics, NodePropertyPredictPipeline pipeline, Iterable<Long> classes) {
        return new ImmutableNodeClassificationPipelineModelInfo(bestParameters, metrics, pipeline, classes);
    }

    public static NodeClassificationPipelineModelInfo copyOf(NodeClassificationPipelineModelInfo instance) {
        if (instance instanceof ImmutableNodeClassificationPipelineModelInfo) {
            return (ImmutableNodeClassificationPipelineModelInfo)instance;
        }
        return ImmutableNodeClassificationPipelineModelInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NodeClassificationPipelineModelInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BEST_PARAMETERS = 1L;
        private static final long INIT_BIT_PIPELINE = 2L;
        private long initBits = 3L;
        @Nullable
        private TrainerConfig bestParameters;
        private Map<String, Object> metrics = null;
        @Nullable
        private NodePropertyPredictPipeline pipeline;
        private List<Long> classes = null;

        private Builder() {
        }

        public final Builder from(NodeClassificationPipelineModelInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.bestParameters(instance.bestParameters());
            this.putAllMetrics(instance.metrics());
            this.pipeline(instance.pipeline());
            this.addAllClasses(instance.classes());
            return this;
        }

        public final Builder bestParameters(TrainerConfig bestParameters) {
            this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putMetric(String key, Object value) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<String, Object>();
            }
            this.metrics.put(Objects.requireNonNull(key, "metrics key"), Objects.requireNonNull(value, "metrics value"));
            return this;
        }

        public final Builder putMetric(Map.Entry<String, ? extends Object> entry) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            return this;
        }

        public final Builder metrics(Map<String, ? extends Object> entries) {
            this.metrics = new LinkedHashMap<String, Object>();
            return this.putAllMetrics(entries);
        }

        public final Builder putAllMetrics(Map<String, ? extends Object> entries) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            }
            return this;
        }

        public final Builder pipeline(NodePropertyPredictPipeline pipeline) {
            this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addClasse(long element) {
            if (this.classes == null) {
                this.classes = new ArrayList<Long>();
            }
            this.classes.add(element);
            return this;
        }

        public final Builder addClasses(long ... elements) {
            if (this.classes == null) {
                this.classes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.classes.add(element);
            }
            return this;
        }

        public final Builder classes(Iterable<Long> elements) {
            this.classes = new ArrayList<Long>();
            return this.addAllClasses(elements);
        }

        public final Builder addAllClasses(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "classes element");
            if (this.classes == null) {
                this.classes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.classes.add(Objects.requireNonNull(Long.valueOf(element), "classes element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.bestParameters = null;
            if (this.metrics != null) {
                this.metrics.clear();
            }
            this.pipeline = null;
            if (this.classes != null) {
                this.classes.clear();
            }
            return this;
        }

        public NodeClassificationPipelineModelInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeClassificationPipelineModelInfo(null, this.bestParameters, this.metrics == null ? Collections.emptyMap() : ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableMap(false, false, this.metrics), this.pipeline, this.classes == null ? Collections.emptyList() : ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(true, this.classes));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bestParameters");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pipeline");
            }
            return "Cannot build NodeClassificationPipelineModelInfo, some of required attributes are not set " + attributes;
        }
    }
}

