/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.classification.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.collections.LongMultiSet;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.NodeClassificationTrainResult;
import org.neo4j.gds.ml.training.TrainingStatistics;

@ParametersAreNonnullByDefault
@Generated(from="NodeClassificationTrainResult", generator="Immutables")
@Immutable
public final class ImmutableNodeClassificationTrainResult
implements NodeClassificationTrainResult {
    private final Classifier classifier;
    private final TrainingStatistics trainingStatistics;
    private final LocalIdMap classIdMap;
    private final LongMultiSet classCounts;

    private ImmutableNodeClassificationTrainResult(Classifier classifier, TrainingStatistics trainingStatistics, LocalIdMap classIdMap, LongMultiSet classCounts) {
        this.classifier = Objects.requireNonNull(classifier, "classifier");
        this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
        this.classIdMap = Objects.requireNonNull(classIdMap, "classIdMap");
        this.classCounts = Objects.requireNonNull(classCounts, "classCounts");
    }

    private ImmutableNodeClassificationTrainResult(ImmutableNodeClassificationTrainResult original, Classifier classifier, TrainingStatistics trainingStatistics, LocalIdMap classIdMap, LongMultiSet classCounts) {
        this.classifier = classifier;
        this.trainingStatistics = trainingStatistics;
        this.classIdMap = classIdMap;
        this.classCounts = classCounts;
    }

    @Override
    public Classifier classifier() {
        return this.classifier;
    }

    @Override
    public TrainingStatistics trainingStatistics() {
        return this.trainingStatistics;
    }

    @Override
    public LocalIdMap classIdMap() {
        return this.classIdMap;
    }

    @Override
    public LongMultiSet classCounts() {
        return this.classCounts;
    }

    public final ImmutableNodeClassificationTrainResult withClassifier(Classifier value) {
        if (this.classifier == value) {
            return this;
        }
        Classifier newValue = Objects.requireNonNull(value, "classifier");
        return new ImmutableNodeClassificationTrainResult(this, newValue, this.trainingStatistics, this.classIdMap, this.classCounts);
    }

    public final ImmutableNodeClassificationTrainResult withTrainingStatistics(TrainingStatistics value) {
        if (this.trainingStatistics == value) {
            return this;
        }
        TrainingStatistics newValue = Objects.requireNonNull(value, "trainingStatistics");
        return new ImmutableNodeClassificationTrainResult(this, this.classifier, newValue, this.classIdMap, this.classCounts);
    }

    public final ImmutableNodeClassificationTrainResult withClassIdMap(LocalIdMap value) {
        if (this.classIdMap == value) {
            return this;
        }
        LocalIdMap newValue = Objects.requireNonNull(value, "classIdMap");
        return new ImmutableNodeClassificationTrainResult(this, this.classifier, this.trainingStatistics, newValue, this.classCounts);
    }

    public final ImmutableNodeClassificationTrainResult withClassCounts(LongMultiSet value) {
        if (this.classCounts == value) {
            return this;
        }
        LongMultiSet newValue = Objects.requireNonNull(value, "classCounts");
        return new ImmutableNodeClassificationTrainResult(this, this.classifier, this.trainingStatistics, this.classIdMap, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationTrainResult && this.equalTo((ImmutableNodeClassificationTrainResult)another);
    }

    private boolean equalTo(ImmutableNodeClassificationTrainResult another) {
        return this.classifier.equals(another.classifier) && this.trainingStatistics.equals(another.trainingStatistics) && this.classIdMap.equals((Object)another.classIdMap) && this.classCounts.equals(another.classCounts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.classifier.hashCode();
        h += (h << 5) + this.trainingStatistics.hashCode();
        h += (h << 5) + this.classIdMap.hashCode();
        h += (h << 5) + this.classCounts.hashCode();
        return h;
    }

    public String toString() {
        return "NodeClassificationTrainResult{classifier=" + this.classifier + ", trainingStatistics=" + this.trainingStatistics + ", classIdMap=" + this.classIdMap + ", classCounts=" + this.classCounts + "}";
    }

    public static NodeClassificationTrainResult of(Classifier classifier, TrainingStatistics trainingStatistics, LocalIdMap classIdMap, LongMultiSet classCounts) {
        return new ImmutableNodeClassificationTrainResult(classifier, trainingStatistics, classIdMap, classCounts);
    }

    public static NodeClassificationTrainResult copyOf(NodeClassificationTrainResult instance) {
        if (instance instanceof ImmutableNodeClassificationTrainResult) {
            return (ImmutableNodeClassificationTrainResult)instance;
        }
        return ImmutableNodeClassificationTrainResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeClassificationTrainResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLASSIFIER = 1L;
        private static final long INIT_BIT_TRAINING_STATISTICS = 2L;
        private static final long INIT_BIT_CLASS_ID_MAP = 4L;
        private static final long INIT_BIT_CLASS_COUNTS = 8L;
        private long initBits = 15L;
        @Nullable
        private Classifier classifier;
        @Nullable
        private TrainingStatistics trainingStatistics;
        @Nullable
        private LocalIdMap classIdMap;
        @Nullable
        private LongMultiSet classCounts;

        private Builder() {
        }

        public final Builder from(NodeClassificationTrainResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.classifier(instance.classifier());
            this.trainingStatistics(instance.trainingStatistics());
            this.classIdMap(instance.classIdMap());
            this.classCounts(instance.classCounts());
            return this;
        }

        public final Builder classifier(Classifier classifier) {
            this.classifier = Objects.requireNonNull(classifier, "classifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder trainingStatistics(TrainingStatistics trainingStatistics) {
            this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder classIdMap(LocalIdMap classIdMap) {
            this.classIdMap = Objects.requireNonNull(classIdMap, "classIdMap");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder classCounts(LongMultiSet classCounts) {
            this.classCounts = Objects.requireNonNull(classCounts, "classCounts");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.classifier = null;
            this.trainingStatistics = null;
            this.classIdMap = null;
            this.classCounts = null;
            return this;
        }

        public NodeClassificationTrainResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeClassificationTrainResult(null, this.classifier, this.trainingStatistics, this.classIdMap, this.classCounts);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("classifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("trainingStatistics");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("classIdMap");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("classCounts");
            }
            return "Cannot build NodeClassificationTrainResult, some of required attributes are not set " + attributes;
        }
    }
}

