/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.regression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.metrics.Metric;
import org.neo4j.gds.ml.metrics.ModelCandidateStats;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPredictPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionPipelineModelInfo;

@ParametersAreNonnullByDefault
@Generated(from="NodeRegressionPipelineModelInfo", generator="Immutables")
@Immutable
public final class ImmutableNodeRegressionPipelineModelInfo
implements NodeRegressionPipelineModelInfo {
    private final Map<Metric, Double> testMetrics;
    private final Map<Metric, Double> outerTrainMetrics;
    private final ModelCandidateStats bestCandidate;
    private final NodePropertyPredictPipeline pipeline;
    private final transient Map<String, Object> toMap;

    private ImmutableNodeRegressionPipelineModelInfo(Map<? extends Metric, ? extends Double> testMetrics, Map<? extends Metric, ? extends Double> outerTrainMetrics, ModelCandidateStats bestCandidate, NodePropertyPredictPipeline pipeline) {
        this.testMetrics = ImmutableNodeRegressionPipelineModelInfo.createUnmodifiableMap(true, false, testMetrics);
        this.outerTrainMetrics = ImmutableNodeRegressionPipelineModelInfo.createUnmodifiableMap(true, false, outerTrainMetrics);
        this.bestCandidate = Objects.requireNonNull(bestCandidate, "bestCandidate");
        this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
        this.toMap = Objects.requireNonNull(NodeRegressionPipelineModelInfo.super.toMap(), "toMap");
    }

    private ImmutableNodeRegressionPipelineModelInfo(ImmutableNodeRegressionPipelineModelInfo original, Map<Metric, Double> testMetrics, Map<Metric, Double> outerTrainMetrics, ModelCandidateStats bestCandidate, NodePropertyPredictPipeline pipeline) {
        this.testMetrics = testMetrics;
        this.outerTrainMetrics = outerTrainMetrics;
        this.bestCandidate = bestCandidate;
        this.pipeline = pipeline;
        this.toMap = Objects.requireNonNull(NodeRegressionPipelineModelInfo.super.toMap(), "toMap");
    }

    @Override
    public Map<Metric, Double> testMetrics() {
        return this.testMetrics;
    }

    @Override
    public Map<Metric, Double> outerTrainMetrics() {
        return this.outerTrainMetrics;
    }

    @Override
    public ModelCandidateStats bestCandidate() {
        return this.bestCandidate;
    }

    @Override
    public NodePropertyPredictPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableNodeRegressionPipelineModelInfo withTestMetrics(Map<? extends Metric, ? extends Double> entries) {
        if (this.testMetrics == entries) {
            return this;
        }
        Map<Metric, Double> newValue = ImmutableNodeRegressionPipelineModelInfo.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodeRegressionPipelineModelInfo(this, newValue, this.outerTrainMetrics, this.bestCandidate, this.pipeline);
    }

    public final ImmutableNodeRegressionPipelineModelInfo withOuterTrainMetrics(Map<? extends Metric, ? extends Double> entries) {
        if (this.outerTrainMetrics == entries) {
            return this;
        }
        Map<Metric, Double> newValue = ImmutableNodeRegressionPipelineModelInfo.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodeRegressionPipelineModelInfo(this, this.testMetrics, newValue, this.bestCandidate, this.pipeline);
    }

    public final ImmutableNodeRegressionPipelineModelInfo withBestCandidate(ModelCandidateStats value) {
        if (this.bestCandidate == value) {
            return this;
        }
        ModelCandidateStats newValue = Objects.requireNonNull(value, "bestCandidate");
        return new ImmutableNodeRegressionPipelineModelInfo(this, this.testMetrics, this.outerTrainMetrics, newValue, this.pipeline);
    }

    public final ImmutableNodeRegressionPipelineModelInfo withPipeline(NodePropertyPredictPipeline value) {
        if (this.pipeline == value) {
            return this;
        }
        NodePropertyPredictPipeline newValue = Objects.requireNonNull(value, "pipeline");
        return new ImmutableNodeRegressionPipelineModelInfo(this, this.testMetrics, this.outerTrainMetrics, this.bestCandidate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeRegressionPipelineModelInfo && this.equalTo((ImmutableNodeRegressionPipelineModelInfo)another);
    }

    private boolean equalTo(ImmutableNodeRegressionPipelineModelInfo another) {
        return this.testMetrics.equals(another.testMetrics) && this.outerTrainMetrics.equals(another.outerTrainMetrics) && this.bestCandidate.equals(another.bestCandidate) && this.pipeline.equals(another.pipeline);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.testMetrics.hashCode();
        h += (h << 5) + this.outerTrainMetrics.hashCode();
        h += (h << 5) + this.bestCandidate.hashCode();
        h += (h << 5) + this.pipeline.hashCode();
        return h;
    }

    public String toString() {
        return "NodeRegressionPipelineModelInfo{testMetrics=" + this.testMetrics + ", outerTrainMetrics=" + this.outerTrainMetrics + ", bestCandidate=" + this.bestCandidate + ", pipeline=" + this.pipeline + "}";
    }

    public static NodeRegressionPipelineModelInfo of(Map<? extends Metric, ? extends Double> testMetrics, Map<? extends Metric, ? extends Double> outerTrainMetrics, ModelCandidateStats bestCandidate, NodePropertyPredictPipeline pipeline) {
        return new ImmutableNodeRegressionPipelineModelInfo(testMetrics, outerTrainMetrics, bestCandidate, pipeline);
    }

    public static NodeRegressionPipelineModelInfo copyOf(NodeRegressionPipelineModelInfo instance) {
        if (instance instanceof ImmutableNodeRegressionPipelineModelInfo) {
            return (ImmutableNodeRegressionPipelineModelInfo)instance;
        }
        return ImmutableNodeRegressionPipelineModelInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NodeRegressionPipelineModelInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BEST_CANDIDATE = 1L;
        private static final long INIT_BIT_PIPELINE = 2L;
        private long initBits = 3L;
        private Map<Metric, Double> testMetrics = null;
        private Map<Metric, Double> outerTrainMetrics = null;
        @Nullable
        private ModelCandidateStats bestCandidate;
        @Nullable
        private NodePropertyPredictPipeline pipeline;

        private Builder() {
        }

        public final Builder from(NodeRegressionPipelineModelInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllTestMetrics(instance.testMetrics());
            this.putAllOuterTrainMetrics(instance.outerTrainMetrics());
            this.bestCandidate(instance.bestCandidate());
            this.pipeline(instance.pipeline());
            return this;
        }

        public final Builder putTestMetric(Metric key, double value) {
            if (this.testMetrics == null) {
                this.testMetrics = new LinkedHashMap<Metric, Double>();
            }
            this.testMetrics.put(Objects.requireNonNull(key, "testMetrics key"), Objects.requireNonNull(Double.valueOf(value), "testMetrics value"));
            return this;
        }

        public final Builder putTestMetric(Map.Entry<? extends Metric, ? extends Double> entry) {
            if (this.testMetrics == null) {
                this.testMetrics = new LinkedHashMap<Metric, Double>();
            }
            Metric k = entry.getKey();
            Double v = entry.getValue();
            this.testMetrics.put(Objects.requireNonNull(k, "testMetrics key"), Objects.requireNonNull(v, "testMetrics value"));
            return this;
        }

        public final Builder testMetrics(Map<? extends Metric, ? extends Double> entries) {
            this.testMetrics = new LinkedHashMap<Metric, Double>();
            return this.putAllTestMetrics(entries);
        }

        public final Builder putAllTestMetrics(Map<? extends Metric, ? extends Double> entries) {
            if (this.testMetrics == null) {
                this.testMetrics = new LinkedHashMap<Metric, Double>();
            }
            for (Map.Entry<? extends Metric, ? extends Double> e : entries.entrySet()) {
                Metric k = e.getKey();
                Double v = e.getValue();
                this.testMetrics.put(Objects.requireNonNull(k, "testMetrics key"), Objects.requireNonNull(v, "testMetrics value"));
            }
            return this;
        }

        public final Builder putOuterTrainMetric(Metric key, double value) {
            if (this.outerTrainMetrics == null) {
                this.outerTrainMetrics = new LinkedHashMap<Metric, Double>();
            }
            this.outerTrainMetrics.put(Objects.requireNonNull(key, "outerTrainMetrics key"), Objects.requireNonNull(Double.valueOf(value), "outerTrainMetrics value"));
            return this;
        }

        public final Builder putOuterTrainMetric(Map.Entry<? extends Metric, ? extends Double> entry) {
            if (this.outerTrainMetrics == null) {
                this.outerTrainMetrics = new LinkedHashMap<Metric, Double>();
            }
            Metric k = entry.getKey();
            Double v = entry.getValue();
            this.outerTrainMetrics.put(Objects.requireNonNull(k, "outerTrainMetrics key"), Objects.requireNonNull(v, "outerTrainMetrics value"));
            return this;
        }

        public final Builder outerTrainMetrics(Map<? extends Metric, ? extends Double> entries) {
            this.outerTrainMetrics = new LinkedHashMap<Metric, Double>();
            return this.putAllOuterTrainMetrics(entries);
        }

        public final Builder putAllOuterTrainMetrics(Map<? extends Metric, ? extends Double> entries) {
            if (this.outerTrainMetrics == null) {
                this.outerTrainMetrics = new LinkedHashMap<Metric, Double>();
            }
            for (Map.Entry<? extends Metric, ? extends Double> e : entries.entrySet()) {
                Metric k = e.getKey();
                Double v = e.getValue();
                this.outerTrainMetrics.put(Objects.requireNonNull(k, "outerTrainMetrics key"), Objects.requireNonNull(v, "outerTrainMetrics value"));
            }
            return this;
        }

        public final Builder bestCandidate(ModelCandidateStats bestCandidate) {
            this.bestCandidate = Objects.requireNonNull(bestCandidate, "bestCandidate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pipeline(NodePropertyPredictPipeline pipeline) {
            this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            if (this.testMetrics != null) {
                this.testMetrics.clear();
            }
            if (this.outerTrainMetrics != null) {
                this.outerTrainMetrics.clear();
            }
            this.bestCandidate = null;
            this.pipeline = null;
            return this;
        }

        public NodeRegressionPipelineModelInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeRegressionPipelineModelInfo(null, this.testMetrics == null ? Collections.emptyMap() : ImmutableNodeRegressionPipelineModelInfo.createUnmodifiableMap(false, false, this.testMetrics), this.outerTrainMetrics == null ? Collections.emptyMap() : ImmutableNodeRegressionPipelineModelInfo.createUnmodifiableMap(false, false, this.outerTrainMetrics), this.bestCandidate, this.pipeline);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bestCandidate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pipeline");
            }
            return "Cannot build NodeRegressionPipelineModelInfo, some of required attributes are not set " + attributes;
        }
    }
}

