/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.regression;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.models.Regressor;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionPipelineModelInfo;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionPipelineTrainConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrainResult;
import org.neo4j.gds.ml.training.TrainingStatistics;

@ParametersAreNonnullByDefault
@Generated(from="NodeRegressionTrainResult.NodeRegressionTrainPipelineResult", generator="Immutables")
@Immutable
public final class ImmutableNodeRegressionTrainPipelineResult
implements NodeRegressionTrainResult.NodeRegressionTrainPipelineResult {
    private final Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> model;
    private final TrainingStatistics trainingStatistics;

    private ImmutableNodeRegressionTrainPipelineResult(Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> model, TrainingStatistics trainingStatistics) {
        this.model = Objects.requireNonNull(model, "model");
        this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
    }

    private ImmutableNodeRegressionTrainPipelineResult(ImmutableNodeRegressionTrainPipelineResult original, Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> model, TrainingStatistics trainingStatistics) {
        this.model = model;
        this.trainingStatistics = trainingStatistics;
    }

    public Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> model() {
        return this.model;
    }

    @Override
    public TrainingStatistics trainingStatistics() {
        return this.trainingStatistics;
    }

    public final ImmutableNodeRegressionTrainPipelineResult withModel(Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> value) {
        if (this.model == value) {
            return this;
        }
        Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> newValue = Objects.requireNonNull(value, "model");
        return new ImmutableNodeRegressionTrainPipelineResult(this, newValue, this.trainingStatistics);
    }

    public final ImmutableNodeRegressionTrainPipelineResult withTrainingStatistics(TrainingStatistics value) {
        if (this.trainingStatistics == value) {
            return this;
        }
        TrainingStatistics newValue = Objects.requireNonNull(value, "trainingStatistics");
        return new ImmutableNodeRegressionTrainPipelineResult(this, this.model, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeRegressionTrainPipelineResult && this.equalTo((ImmutableNodeRegressionTrainPipelineResult)another);
    }

    private boolean equalTo(ImmutableNodeRegressionTrainPipelineResult another) {
        return this.model.equals(another.model) && this.trainingStatistics.equals(another.trainingStatistics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.trainingStatistics.hashCode();
        return h;
    }

    public String toString() {
        return "NodeRegressionTrainPipelineResult{model=" + this.model + ", trainingStatistics=" + this.trainingStatistics + "}";
    }

    public static NodeRegressionTrainResult.NodeRegressionTrainPipelineResult of(Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> model, TrainingStatistics trainingStatistics) {
        return new ImmutableNodeRegressionTrainPipelineResult(model, trainingStatistics);
    }

    public static NodeRegressionTrainResult.NodeRegressionTrainPipelineResult copyOf(NodeRegressionTrainResult.NodeRegressionTrainPipelineResult instance) {
        if (instance instanceof ImmutableNodeRegressionTrainPipelineResult) {
            return (ImmutableNodeRegressionTrainPipelineResult)instance;
        }
        return ImmutableNodeRegressionTrainPipelineResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeRegressionTrainResult.NodeRegressionTrainPipelineResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL = 1L;
        private static final long INIT_BIT_TRAINING_STATISTICS = 2L;
        private long initBits = 3L;
        @Nullable
        private Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> model;
        @Nullable
        private TrainingStatistics trainingStatistics;

        private Builder() {
        }

        public final Builder from(NodeRegressionTrainResult.NodeRegressionTrainPipelineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.model((Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo>)instance.model());
            this.trainingStatistics(instance.trainingStatistics());
            return this;
        }

        public final Builder model(Model<Regressor.RegressorData, NodeRegressionPipelineTrainConfig, NodeRegressionPipelineModelInfo> model) {
            this.model = Objects.requireNonNull(model, "model");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder trainingStatistics(TrainingStatistics trainingStatistics) {
            this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.model = null;
            this.trainingStatistics = null;
            return this;
        }

        public NodeRegressionTrainResult.NodeRegressionTrainPipelineResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeRegressionTrainPipelineResult(null, this.model, this.trainingStatistics);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("model");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("trainingStatistics");
            }
            return "Cannot build NodeRegressionTrainPipelineResult, some of required attributes are not set " + attributes;
        }
    }
}

