/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.generator;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.beta.generator.PropertyProducer;
import org.neo4j.gds.beta.generator.RandomGraphGenerator;
import org.neo4j.gds.beta.generator.RandomGraphGeneratorBuilder;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.RandomGraphGeneratorConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.CSRGraphStoreUtil;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class GraphGenerateProc
extends BaseProc {
    @Procedure(name="gds.beta.graph.generate", mode=Mode.READ)
    @Description(value="Computes a random graph, which will be stored in the graph catalog.")
    public Stream<GraphGenerationStats> generate(@Name(value="graphName") String graphName, @Name(value="nodeCount") long nodeCount, @Name(value="averageDegree") long averageDegree, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        this.validateGraphName(this.username(), graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        RandomGraphGeneratorConfig config = RandomGraphGeneratorConfig.of((String)this.username(), (String)graphName, (long)nodeCount, (long)averageDegree, (CypherMapWrapper)cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)config);
        GraphGenerationStats result = (GraphGenerationStats)this.runWithExceptionLogging("Graph creation failed", () -> this.generateGraph(graphName, nodeCount, averageDegree, config));
        return Stream.of(result);
    }

    private GraphGenerationStats generateGraph(String name, long nodeCount, long averageDegree, RandomGraphGeneratorConfig config) {
        GraphGenerationStats stats = new GraphGenerationStats(name, averageDegree, config);
        try (ProgressTimer ignored = ProgressTimer.start(time -> {
            stats.generateMillis = time;
        });){
            RandomGraphGenerator generator = this.initializeGraphGenerator(nodeCount, averageDegree, config);
            HugeGraph graph = generator.generate();
            Optional<String> relationshipProperty = generator.getMaybeRelationshipPropertyProducer().map(PropertyProducer::getPropertyName);
            CSRGraphStore graphStore = CSRGraphStoreUtil.createFromGraph((DatabaseId)DatabaseId.of((GraphDatabaseService)this.databaseService), (HugeGraph)graph, relationshipProperty, (int)config.readConcurrency());
            stats.nodes = graphStore.nodeCount();
            stats.relationships = graphStore.relationshipCount();
            GraphStoreCatalog.set((GraphProjectConfig)config, (GraphStore)graphStore);
        }
        return stats;
    }

    RandomGraphGenerator initializeGraphGenerator(long nodeCount, long averageDegree, RandomGraphGeneratorConfig config) {
        RandomGraphGeneratorBuilder builder = RandomGraphGenerator.builder().nodeCount(nodeCount).averageDegree(averageDegree).relationshipDistribution(config.relationshipDistribution()).relationshipType(config.relationshipType()).aggregation(config.aggregation()).direction(Direction.fromOrientation((Orientation)config.orientation())).allowSelfLoops(RandomGraphGeneratorConfig.AllowSelfLoops.of((boolean)config.allowSelfLoops()));
        if (config.relationshipSeed() != null) {
            builder.seed(config.relationshipSeed().longValue());
        }
        Optional<PropertyProducer<double[]>> maybeProducer = this.getRelationshipPropertyProducer(config.relationshipProperty());
        maybeProducer.ifPresent(arg_0 -> ((RandomGraphGeneratorBuilder)builder).relationshipPropertyProducer(arg_0));
        return builder.build();
    }

    private Optional<PropertyProducer<double[]>> getRelationshipPropertyProducer(Map<String, Object> configMap) {
        PropertyProducer propertyProducer;
        if (configMap.isEmpty()) {
            return Optional.empty();
        }
        CypherMapWrapper config = CypherMapWrapper.create(configMap);
        String propertyName = config.requireString("name");
        String generatorString = config.requireString("type");
        switch (generatorString.toLowerCase(Locale.ENGLISH)) {
            case "random": {
                double min = config.getDouble("min", 0.0);
                double max = config.getDouble("max", 1.0);
                propertyProducer = PropertyProducer.randomDouble((String)propertyName, (double)min, (double)max);
                break;
            }
            case "fixed": {
                double value = config.requireDouble("value");
                propertyProducer = PropertyProducer.fixedDouble((String)propertyName, (double)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Relationship property generator: " + generatorString);
            }
        }
        return Optional.of(propertyProducer);
    }

    public static class GraphGenerationStats {
        public String name;
        public long nodes;
        public long relationships;
        public long generateMillis;
        public Long relationshipSeed;
        public double averageDegree;
        public Object relationshipDistribution;
        public Object relationshipProperty;

        GraphGenerationStats(String graphName, double averageDegree, RandomGraphGeneratorConfig configuration) {
            this.name = graphName;
            this.averageDegree = averageDegree;
            this.relationshipDistribution = configuration.relationshipDistribution().name();
            this.relationshipProperty = configuration.relationshipProperty();
            this.relationshipSeed = configuration.relationshipSeed();
        }
    }
}

