/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.catalog.ImmutableGraphDropConfig;
import org.neo4j.gds.config.BaseConfig;

@ValueClass
public interface GraphDropConfig
extends BaseConfig {
    @Value.Default
    default public boolean failIfMissing() {
        return true;
    }

    public Optional<String> databaseName();

    default public Optional<String> catalogUser() {
        return this.usernameOverride();
    }

    public static GraphDropConfig of(boolean failIfMissing, String database, String username) {
        return ImmutableGraphDropConfig.builder().failIfMissing(failIfMissing).databaseName(StringUtils.trimToNull((String)database)).usernameOverride(StringUtils.trimToNull((String)username)).build();
    }
}

