/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphRemoveGraphPropertiesConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphDropGraphPropertiesProc
extends CatalogProc {
    @Procedure(name="gds.alpha.graph.graphProperty.drop", mode=Mode.READ)
    @Description(value="Removes a graph property from a projected graph.")
    public Stream<Result> run(@Name(value="graphName") String graphName, @Name(value="graphProperty") String graphProperty, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphRemoveGraphPropertiesConfig config = GraphRemoveGraphPropertiesConfig.of((String)graphName, (String)graphProperty, (CypherMapWrapper)cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)config).graphStore();
        config.validate(graphStore);
        long propertiesRemoved = graphStore.graphPropertyValues(graphProperty).valueCount();
        this.runWithExceptionLogging("Graph property removal failed", () -> graphStore.removeGraphProperty(graphProperty));
        return Stream.of(new Result(graphName, graphProperty, propertiesRemoved));
    }

    public static class Result {
        public final String graphName;
        public final String graphProperty;
        public final long propertiesRemoved;

        Result(String graphName, String graphProperty, long propertiesRemoved) {
            this.graphName = graphName;
            this.graphProperty = graphProperty;
            this.propertiesRemoved = propertiesRemoved;
        }
    }
}

