/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.GraphDropNodePropertiesConfigImpl;
import org.neo4j.gds.catalog.UserInputAsStringOrListOfString;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@ValueClass
@Configuration
public interface GraphDropNodePropertiesConfig
extends BaseConfig,
ConcurrencyConfig {
    @Configuration.Parameter
    public Optional<String> graphName();

    @Configuration.Parameter
    @Configuration.ConvertWith(method="org.neo4j.gds.catalog.GraphDropNodePropertiesConfig#parseNodeProperties")
    public List<String> nodeProperties();

    public static List<String> parseNodeProperties(Object userInput) {
        return UserInputAsStringOrListOfString.parse(userInput, "nodeProperties");
    }

    public static GraphDropNodePropertiesConfig of(String graphName, Object nodeProperties, CypherMapWrapper config) {
        return new GraphDropNodePropertiesConfigImpl(Optional.of(graphName), nodeProperties, (CypherMapAccess)config);
    }

    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        List invalidProperties = this.nodeProperties().stream().filter(nodeProperty -> !graphStore.hasNodeProperty(nodeProperty)).collect(Collectors.toList());
        if (!invalidProperties.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Could not find property key(s) %s. Defined keys: %s.", (Object[])new Object[]{StringJoining.join(invalidProperties), StringJoining.join((Collection)graphStore.nodePropertyKeys())}));
        }
    }
}

