/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.catalog.GraphDropNodePropertiesConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphDropNodePropertiesProc
extends CatalogProc {
    @Procedure(name="gds.graph.nodeProperties.drop", mode=Mode.READ)
    @Description(value="Removes node properties from a projected graph.")
    public Stream<Result> dropNodeProperties(@Name(value="graphName") String graphName, @Name(value="nodeProperties") @NotNull Object nodeProperties, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.dropNodeProperties(graphName, nodeProperties, configuration, Optional.empty());
    }

    @Procedure(name="gds.graph.removeNodeProperties", mode=Mode.READ, deprecatedBy="gds.graph.nodeProperties.drop")
    @Description(value="Removes node properties from a projected graph.")
    public Stream<Result> run(@Name(value="graphName") String graphName, @Name(value="nodeProperties") @NotNull Object nodeProperties, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.nodeProperties.drop`";
        return this.dropNodeProperties(graphName, nodeProperties, configuration, Optional.of(deprecationWarning));
    }

    private Stream<Result> dropNodeProperties(String graphName, Object nodeProperties, Map<String, Object> configuration, Optional<String> deprecationWarning) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphDropNodePropertiesConfig config = GraphDropNodePropertiesConfig.of(graphName, nodeProperties, cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, config).graphStore();
        config.validate(graphStore);
        LeafTask task = Tasks.leaf((String)"Graph :: NodeProperties :: Drop", (long)config.nodeProperties().size());
        TaskProgressTracker progressTracker = new TaskProgressTracker((Task)task, this.log, 1, new JobId(), this.taskRegistryFactory, this.userLogRegistryFactory);
        deprecationWarning.ifPresent(arg_0 -> ((TaskProgressTracker)progressTracker).logWarning(arg_0));
        long propertiesRemoved = (Long)this.runWithExceptionLogging("Node property removal failed", () -> this.dropNodeProperties(graphStore, config, progressTracker));
        return Stream.of(new Result(graphName, config.nodeProperties(), propertiesRemoved));
    }

    @NotNull
    private Long dropNodeProperties(GraphStore graphStore, GraphDropNodePropertiesConfig config, TaskProgressTracker progressTracker) {
        MutableLong removedPropertiesCount = new MutableLong(0L);
        progressTracker.beginSubTask();
        config.nodeProperties().forEach(propertyKey -> {
            removedPropertiesCount.add(((NodePropertyValues)graphStore.nodeProperty(propertyKey).values()).nodeCount());
            graphStore.removeNodeProperty(propertyKey);
            progressTracker.logProgress();
        });
        progressTracker.endSubTask();
        return removedPropertiesCount.longValue();
    }

    public static class Result {
        public final String graphName;
        public final List<String> nodeProperties;
        public final long propertiesRemoved;

        Result(String graphName, List<String> nodeProperties, long propertiesRemoved) {
            this.graphName = graphName;
            this.nodeProperties = nodeProperties.stream().sorted().collect(Collectors.toList());
            this.propertiesRemoved = propertiesRemoved;
        }
    }
}

