/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.catalog.GraphDropConfig;
import org.neo4j.gds.catalog.GraphInfo;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.ImmutableCatalogRequest;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphDropProc
extends CatalogProc {
    private static final String DESCRIPTION = "Drops a named graph from the catalog and frees up the resources it occupies.";

    @Procedure(name="gds.graph.drop", mode=Mode.READ)
    @Description(value="Drops a named graph from the catalog and frees up the resources it occupies.")
    public Stream<GraphInfo> drop(@Name(value="graphName") Object graphName, @Name(value="failIfMissing", defaultValue="true") boolean failIfMissing, @Name(value="dbName", defaultValue="") String dbName, @Name(value="username", defaultValue="") String username) {
        List<MissingGraph> missingGraphs;
        List<Object> graphNames;
        ProcPreconditions.check();
        if (graphName instanceof Collection) {
            Collection names = (Collection)graphName;
            graphNames = new ArrayList(names.size());
            int index = 0;
            for (Object name2 : names) {
                if (!(name2 instanceof String) && name2 != null) {
                    throw this.typeMismatch(name2, index);
                }
                graphNames.add(this.validateGraphName((String)name2));
                ++index;
            }
        } else if (graphName instanceof String || graphName == null) {
            graphNames = List.of(this.validateGraphName((String)graphName));
        } else {
            throw this.typeMismatch(graphName, -1);
        }
        GraphDropConfig config = GraphDropConfig.of(failIfMissing, dbName, username);
        CatalogRequest request = ImmutableCatalogRequest.of((String)config.databaseName().orElseGet(() -> ((DatabaseId)this.databaseId()).databaseName()), (String)this.username(), config.catalogUser(), (boolean)this.isGdsAdmin());
        if (failIfMissing && !(missingGraphs = graphNames.stream().flatMap(name -> {
            try {
                GraphStoreCatalog.get((CatalogRequest)request, (String)name);
                return Stream.empty();
            }
            catch (NoSuchElementException missing) {
                return Stream.of(new MissingGraph((String)name, missing));
            }
        }).collect(Collectors.toList())).isEmpty()) {
            throw this.missingGraphs(missingGraphs, request.databaseName());
        }
        Stream.Builder result = Stream.builder();
        for (String string : graphNames) {
            GraphStoreCatalog.remove((CatalogRequest)request, (String)string, graphStoreWithConfig -> result.add(GraphInfo.withoutMemoryUsage(graphStoreWithConfig.config(), graphStoreWithConfig.graphStore())), (boolean)failIfMissing);
        }
        return result.build();
    }

    private IllegalArgumentException typeMismatch(@NotNull Object invalid, int index) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Type mismatch%s: expected String but was %s.", (Object[])new Object[]{index >= 0 ? " at index " + index : "", invalid.getClass().getSimpleName()}));
    }

    private NoSuchElementException missingGraphs(List<MissingGraph> missingGraphs, String dbName) {
        if (missingGraphs.size() == 1) {
            return missingGraphs.get((int)0).exception;
        }
        StringBuilder message = new StringBuilder("The graphs");
        for (int i = 0; i < missingGraphs.size() - 1; ++i) {
            message.append(" `").append(missingGraphs.get((int)i).name).append("`,");
        }
        message.append(" and `").append(missingGraphs.get((int)(missingGraphs.size() - 1)).name).append("` do not exist on database `").append(dbName).append("`.");
        NoSuchElementException exception = new NoSuchElementException(message.toString());
        for (MissingGraph missingGraph : missingGraphs) {
            exception.addSuppressed(missingGraph.exception);
        }
        return exception;
    }

    private static final class MissingGraph {
        private final String name;
        private final NoSuchElementException exception;

        private MissingGraph(String name, NoSuchElementException exception) {
            this.name = name;
            this.exception = exception;
        }
    }
}

