/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.DeleteRelationshipsConfig;
import org.neo4j.gds.core.loading.DeletionResult;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphDropRelationshipProc
extends CatalogProc {
    private static final String DESCRIPTION = "Delete the relationship type for a given graph stored in the graph-catalog.";

    @Procedure(name="gds.graph.relationships.drop", mode=Mode.READ)
    @Description(value="Delete the relationship type for a given graph stored in the graph-catalog.")
    public Stream<Result> dropRelationships(@Name(value="graphName") String graphName, @Name(value="relationshipType") String relationshipType) {
        return this.dropRelationships(graphName, relationshipType, Optional.empty());
    }

    @Procedure(name="gds.graph.deleteRelationships", mode=Mode.READ, deprecatedBy="gds.graph.relationships.drop")
    @Description(value="Delete the relationship type for a given graph stored in the graph-catalog.")
    public Stream<Result> delete(@Name(value="graphName") String graphName, @Name(value="relationshipType") String relationshipType) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.relationships.drop`";
        return this.dropRelationships(graphName, relationshipType, Optional.of(deprecationWarning));
    }

    private Stream<Result> dropRelationships(String graphName, String relationshipType, Optional<String> deprecationWarning) {
        ProcPreconditions.check();
        GraphStoreWithConfig graphStoreWithConfig = this.graphStoreFromCatalog(graphName);
        DeleteRelationshipsConfig.of((String)graphName, (String)relationshipType).validate(graphStoreWithConfig.graphStore());
        LeafTask task = Tasks.leaf((String)"Graph :: Relationships :: Drop", (long)1L);
        TaskProgressTracker progressTracker = new TaskProgressTracker((Task)task, this.log, 1, new JobId(), this.taskRegistryFactory, this.userLogRegistryFactory);
        deprecationWarning.ifPresent(arg_0 -> ((TaskProgressTracker)progressTracker).logWarning(arg_0));
        progressTracker.beginSubTask();
        DeletionResult deletionResult = graphStoreWithConfig.graphStore().deleteRelationships(RelationshipType.of((String)relationshipType));
        progressTracker.endSubTask();
        return Stream.of(new Result(graphName, relationshipType, deletionResult));
    }

    public static class Result {
        public final String graphName;
        public final String relationshipType;
        public final long deletedRelationships;
        public final Map<String, Long> deletedProperties;

        Result(String graphName, String relationshipType, DeletionResult deletionResult) {
            this.graphName = graphName;
            this.relationshipType = relationshipType;
            this.deletedRelationships = deletionResult.deletedRelationships();
            this.deletedProperties = deletionResult.deletedProperties();
        }
    }
}

