/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.stream.Stream;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphExistsProc
extends CatalogProc {
    private static final String DESCRIPTION = "Checks if a graph exists in the catalog.";

    @Procedure(name="gds.graph.exists", mode=Mode.READ)
    @Description(value="Checks if a graph exists in the catalog.")
    public Stream<GraphExistsResult> exists(@Name(value="graphName") String graphName) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        return Stream.of(new GraphExistsResult(graphName, GraphStoreCatalog.exists((String)this.username(), (DatabaseId)this.databaseId(), (String)graphName)));
    }

    public static class GraphExistsResult {
        public final String graphName;
        public final boolean exists;

        GraphExistsResult(String graphName, boolean exists) {
            this.graphName = graphName;
            this.exists = exists;
        }
    }
}

