/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.GraphInfoHelper;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.config.GraphProjectFromGraphConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.config.GraphSampleProcConfig;
import org.neo4j.gds.config.RandomGraphGeneratorConfig;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.projection.GraphProjectFromCypherAggregationConfig;

public class GraphInfo {
    public final String graphName;
    public final String database;
    public final String memoryUsage;
    public final long sizeInBytes;
    public final long nodeCount;
    public final long relationshipCount;
    public final Map<String, Object> configuration;
    public final double density;
    public final ZonedDateTime creationTime;
    public final ZonedDateTime modificationTime;
    @Deprecated(forRemoval=true)
    public final Map<String, Object> schema;
    public final Map<String, Object> schemaWithOrientation;

    GraphInfo(String graphName, String database, Map<String, Object> configuration, String memoryUsage, long sizeInBytes, long nodeCount, long relationshipCount, ZonedDateTime creationTime, ZonedDateTime modificationTime, Map<String, Object> schema, Map<String, Object> schemaWithOrientation) {
        this.graphName = graphName;
        this.database = database;
        this.memoryUsage = memoryUsage;
        this.sizeInBytes = sizeInBytes;
        this.nodeCount = nodeCount;
        this.relationshipCount = relationshipCount;
        this.density = GraphInfoHelper.density(nodeCount, relationshipCount);
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.schema = schema;
        this.schemaWithOrientation = schemaWithOrientation;
        this.configuration = configuration;
    }

    static GraphInfo withMemoryUsage(GraphProjectConfig graphProjectConfig, GraphStore graphStore) {
        long sizeInBytes = MemoryUsage.sizeOf((Object)graphStore);
        String memoryUsage = sizeInBytes >= 0L ? MemoryUsage.humanReadable((long)sizeInBytes) : null;
        return GraphInfo.create(graphProjectConfig, graphStore, memoryUsage, sizeInBytes);
    }

    static GraphInfo withoutMemoryUsage(GraphProjectConfig graphProjectConfig, GraphStore graphStore) {
        return GraphInfo.create(graphProjectConfig, graphStore, "", -1L);
    }

    private static GraphInfo create(GraphProjectConfig graphProjectConfig, GraphStore graphStore, String memoryUsage, long sizeInBytes) {
        Visitor configVisitor = new Visitor();
        graphProjectConfig.accept((GraphProjectConfig.Cases)configVisitor);
        return new GraphInfo(graphProjectConfig.graphName(), graphStore.databaseId().databaseName(), configVisitor.configuration, memoryUsage, sizeInBytes, graphStore.nodeCount(), graphStore.relationshipCount(), graphProjectConfig.creationTime(), graphStore.modificationTime(), graphStore.schema().toMapOld(), graphStore.schema().toMap());
    }

    static final class Visitor
    implements GraphProjectConfig.Visitor,
    GraphProjectFromCypherAggregationConfig.Visitor {
        Map<String, Object> configuration = null;

        Visitor() {
        }

        public void visit(GraphProjectFromStoreConfig storeConfig) {
            this.configuration = this.cleansed(storeConfig.toMap(), storeConfig.outputFieldDenylist());
        }

        public void visit(GraphProjectFromCypherConfig cypherConfig) {
            this.configuration = this.cleansed(cypherConfig.toMap(), cypherConfig.outputFieldDenylist());
        }

        public void visit(GraphProjectFromCypherAggregationConfig cypherAggregationConfig) {
            this.configuration = this.cleansed(cypherAggregationConfig.toMap(), cypherAggregationConfig.outputFieldDenylist());
        }

        public void visit(GraphProjectFromGraphConfig graphConfig) {
            graphConfig.originalConfig().accept((GraphProjectConfig.Cases)this);
            this.configuration.putAll(graphConfig.toMap());
            this.configuration.put("nodeFilter", graphConfig.nodeFilter());
            this.configuration.put("relationshipFilter", graphConfig.relationshipFilter());
        }

        public void visit(RandomGraphGeneratorConfig randomGraphConfig) {
            this.configuration = this.cleansed(randomGraphConfig.toMap(), randomGraphConfig.outputFieldDenylist());
        }

        public void visit(GraphSampleProcConfig sampleProcConfig) {
            sampleProcConfig.originalConfig().accept((GraphProjectConfig.Cases)this);
            Map<String, Object> cleansedSampleAlgoConfig = this.cleansed(sampleProcConfig.sampleAlgoConfig().toMap(), sampleProcConfig.sampleAlgoConfig().outputFieldDenylist());
            this.configuration.putAll(cleansedSampleAlgoConfig);
        }

        private Map<String, Object> cleansed(Map<String, Object> map, Collection<String> keysToIgnore) {
            HashMap<String, Object> result = new HashMap<String, Object>(map);
            map.forEach((key, value) -> {
                if (keysToIgnore.contains(key)) {
                    result.remove(key);
                }
            });
            return result;
        }
    }
}

