/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ExecutorService;
import org.HdrHistogram.AtomicHistogram;
import org.neo4j.gds.api.BatchNodeIterable;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.compat.MapUtil;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;

public final class GraphInfoHelper {
    private static final int PRECISION = 5;

    private GraphInfoHelper() {
    }

    public static Map<String, Object> degreeDistribution(Graph graph) {
        int batchSize = Math.toIntExact(ParallelUtil.adjustedBatchSize((long)graph.nodeCount(), (int)4, (long)10000L));
        long maximumDegree = Math.max(2L, graph.relationshipCount());
        AtomicHistogram histogram = new AtomicHistogram(maximumDegree, 5);
        ParallelUtil.readParallel((int)4, (int)batchSize, (BatchNodeIterable)graph, (ExecutorService)Pools.DEFAULT, (nodeOffset, nodeIds) -> () -> {
            PrimitiveIterator.OfLong iterator = nodeIds.iterator();
            while (iterator.hasNext()) {
                long nodeId = iterator.nextLong();
                int degree = graph.degree(nodeId);
                histogram.recordValue((long)degree);
            }
        });
        return MapUtil.map((Object[])new Object[]{"min", histogram.getMinValue(), "mean", histogram.getMean(), "max", histogram.getMaxValue(), "p50", histogram.getValueAtPercentile(50.0), "p75", histogram.getValueAtPercentile(75.0), "p90", histogram.getValueAtPercentile(90.0), "p95", histogram.getValueAtPercentile(95.0), "p99", histogram.getValueAtPercentile(99.0), "p999", histogram.getValueAtPercentile(99.9)});
    }

    public static double density(long nodeCount, long relationshipCount) {
        return nodeCount > 0L ? (double)relationshipCount / (double)(nodeCount * (nodeCount - 1L)) : 0.0;
    }

    public static double density(Graph graph) {
        return GraphInfoHelper.density(graph.nodeCount(), graph.relationshipCount());
    }
}

