/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.GraphInfo;
import org.neo4j.gds.catalog.GraphInfoHelper;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.loading.GraphStoreCatalog;

public class GraphInfoWithHistogram
extends GraphInfo {
    public final Map<String, Object> degreeDistribution;

    public GraphInfoWithHistogram(GraphInfo graphInfo, @Nullable Map<String, Object> degreeDistribution) {
        super(graphInfo.graphName, graphInfo.database, graphInfo.configuration, graphInfo.memoryUsage, graphInfo.sizeInBytes, graphInfo.nodeCount, graphInfo.relationshipCount, graphInfo.creationTime, graphInfo.modificationTime, graphInfo.schema, graphInfo.schemaWithOrientation);
        this.degreeDistribution = degreeDistribution;
    }

    static GraphInfoWithHistogram of(GraphProjectConfig graphProjectConfig, GraphStore graphStore, boolean computeHistogram, boolean computeGraphSize) {
        GraphInfo graphInfo = computeGraphSize ? GraphInfo.withMemoryUsage(graphProjectConfig, graphStore) : GraphInfo.withoutMemoryUsage(graphProjectConfig, graphStore);
        Optional maybeDegreeDistribution = GraphStoreCatalog.getDegreeDistribution((String)graphProjectConfig.username(), (DatabaseId)graphStore.databaseId(), (String)graphProjectConfig.graphName());
        Map degreeDistribution = maybeDegreeDistribution.orElseGet(() -> {
            if (computeHistogram) {
                Map<String, Object> newHistogram = GraphInfoHelper.degreeDistribution(graphStore.getUnion());
                GraphStoreCatalog.setDegreeDistribution((String)graphProjectConfig.username(), (DatabaseId)graphStore.databaseId(), (String)graphProjectConfig.graphName(), newHistogram);
                return newHistogram;
            }
            return null;
        });
        return new GraphInfoWithHistogram(graphInfo, degreeDistribution);
    }
}

