/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.catalog.GraphInfoWithHistogram;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphListProc
extends CatalogProc {
    private static final String NO_VALUE = "__NO_VALUE";
    private static final String DESCRIPTION = "Lists information about named graphs stored in the catalog.";

    @Procedure(name="gds.graph.list", mode=Mode.READ)
    @Description(value="Lists information about named graphs stored in the catalog.")
    public Stream<GraphInfoWithHistogram> list(@Name(value="graphName", defaultValue="__NO_VALUE") String graphName) {
        Stream<Map.Entry> graphEntries;
        ProcPreconditions.check();
        Stream stream = graphEntries = this.isGdsAdmin() ? GraphStoreCatalog.getAllGraphStores().map(graphStore -> Map.entry(graphStore.config(), graphStore.graphStore())) : GraphStoreCatalog.getGraphStores((String)this.username()).entrySet().stream();
        if (graphName != null && !graphName.equals(NO_VALUE)) {
            this.validateGraphName(graphName);
            graphEntries = graphEntries.filter(e -> ((GraphProjectConfig)e.getKey()).graphName().equals(graphName));
        }
        return graphEntries.map(e -> {
            GraphProjectConfig graphProjectConfig = (GraphProjectConfig)e.getKey();
            GraphStore graphStore = (GraphStore)e.getValue();
            boolean computeDegreeDistribution = this.callContext.outputFields().anyMatch(s -> s.equalsIgnoreCase("degreeDistribution"));
            boolean computeGraphSize = this.callContext.outputFields().anyMatch(s -> s.equalsIgnoreCase("memoryUsage") || s.equalsIgnoreCase("sizeInBytes"));
            return GraphInfoWithHistogram.of(graphProjectConfig, graphStore, computeDegreeDistribution, computeGraphSize);
        });
    }
}

