/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.openjdk.jol.info.GraphVisitor;
import org.openjdk.jol.info.GraphWalker;

public class GraphMemoryUsageProc
extends CatalogProc {
    @Internal
    @Procedure(name="gds.internal.graph.sizeOf", mode=Mode.READ)
    public Stream<GraphMemoryUsage> list(@Name(value="graphName") String graphName) {
        ProcPreconditions.check();
        graphName = Objects.requireNonNull(StringUtils.trimToNull((String)graphName), "graphName must not be empty");
        GraphStoreWithConfig graphStoreWithConfig = this.graphStoreFromCatalog(graphName);
        GraphMemoryUsage memoryUsage = GraphMemoryUsage.of(graphStoreWithConfig);
        return Stream.of(memoryUsage);
    }

    public static class GraphMemoryUsage {
        public final String graphName;
        public final String memoryUsage;
        public final long sizeInBytes;
        public final Map<String, Object> detailSizeInBytes;
        public final long nodeCount;
        public final long relationshipCount;
        private static final Pattern ADJ_DEGREES = Pattern.compile("^.relationships.table\\[\\d+].value.degrees.*$");
        private static final Pattern ADJ_LIST = Pattern.compile("^.relationships.table\\[\\d+].value.list.*$");
        private static final Pattern ADJ_OFFSETS = Pattern.compile("^.relationships.table\\[\\d+].value.offsets.*$");
        private static final Pattern DOT = Pattern.compile("\\.");
        private static final Object DUMMY = new Object();

        GraphMemoryUsage(String graphName, String memoryUsage, long sizeInBytes, Map<String, Object> detailSizeInBytes, long nodeCount, long relationshipCount) {
            this.graphName = graphName;
            this.memoryUsage = memoryUsage;
            this.sizeInBytes = sizeInBytes;
            this.detailSizeInBytes = detailSizeInBytes;
            this.nodeCount = nodeCount;
            this.relationshipCount = relationshipCount;
        }

        static GraphMemoryUsage of(GraphStoreWithConfig graphStoreWithConfig) {
            MutableLong totalSize = new MutableLong();
            Map<String, Object> detailMemory = GraphMemoryUsage.internalSizeOfGraph(graphStoreWithConfig.graphStore(), totalSize);
            String memoryUsage = MemoryUsage.humanReadable((long)totalSize.longValue());
            return new GraphMemoryUsage(graphStoreWithConfig.config().graphName(), memoryUsage, totalSize.longValue(), detailMemory, graphStoreWithConfig.graphStore().nodeCount(), graphStoreWithConfig.graphStore().relationshipCount());
        }

        private static Map<String, Object> internalSizeOfGraph(GraphStore graphStore, MutableLong totalSize) {
            if (MemoryUsage.sizeOf((Object)DUMMY) == -1L) {
                return Map.of();
            }
            MutableLong mappingSparseLongArray = new MutableLong();
            MutableLong mappingForward = new MutableLong();
            MutableLong mappingBackward = new MutableLong();
            MutableLong nodesTotal = new MutableLong();
            MutableLong adjacencyDegrees = new MutableLong();
            MutableLong adjacencyOffsets = new MutableLong();
            MutableLong adjacencyLists = new MutableLong();
            MutableLong relationshipsTotal = new MutableLong();
            GraphWalker graphWalker = new GraphWalker(new GraphVisitor[]{gpr -> {
                long size = gpr.size();
                String path = gpr.path();
                String firstField = DOT.splitAsStream(path).skip(1L).findFirst().orElse("");
                if ("nodes".equals(firstField)) {
                    nodesTotal.add(size);
                } else if ("relationships".equals(firstField)) {
                    relationshipsTotal.add(size);
                }
                if (path.startsWith(".nodes.sparseLongArray")) {
                    mappingSparseLongArray.add(size);
                }
                if (path.startsWith(".nodes.graphIds")) {
                    mappingForward.add(size);
                }
                if (path.startsWith(".nodes.nodeToGraphIds")) {
                    mappingBackward.add(size);
                }
                if (ADJ_DEGREES.matcher(path).matches()) {
                    adjacencyDegrees.add(size);
                }
                if (ADJ_LIST.matcher(path).matches()) {
                    adjacencyLists.add(size);
                }
                if (ADJ_OFFSETS.matcher(path).matches()) {
                    adjacencyOffsets.add(size);
                }
                totalSize.add(size);
            }});
            graphWalker.walk(new Object[]{graphStore});
            long mappingTotal = mappingSparseLongArray.longValue() + mappingForward.longValue() + mappingBackward.longValue();
            long adjacencyTotal = adjacencyDegrees.longValue() + adjacencyOffsets.longValue() + adjacencyLists.longValue();
            return Map.of("total", totalSize.longValue(), "nodes", Map.of("sparseLongArray", mappingSparseLongArray.longValue(), "forwardMapping", mappingForward.longValue(), "backwardMapping", mappingBackward.longValue(), "mapping", mappingTotal, "total", nodesTotal.longValue()), "relationships", Map.of("degrees", adjacencyDegrees.longValue(), "offsets", adjacencyOffsets.longValue(), "targetIds", adjacencyLists.longValue(), "adjacencyLists", adjacencyTotal, "total", relationshipsTotal.longValue()));
        }
    }
}

