/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.beta.filter.NodesFilter;
import org.neo4j.gds.beta.filter.expression.Expression;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.catalog.MutateLabelResult;
import org.neo4j.gds.catalog.NodeFilterParser;
import org.neo4j.gds.config.MutateLabelConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.opencypher.v9_0.parser.javacc.ParseException;

public class GraphMutateNodeLabelProc
extends CatalogProc {
    @Procedure(name="gds.alpha.graph.nodeLabel.mutate", mode=Mode.READ)
    @Description(value="Mutates the in-memory graph with the given node Label.")
    public Stream<MutateLabelResult> mutate(@Name(value="graphName") String graphName, @Name(value="nodeLabel") String nodeLabel, @Name(value="configuration") Map<String, Object> configuration) throws ParseException {
        ProcPreconditions.check();
        MutateLabelConfig procedureConfig = MutateLabelConfig.of(configuration);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName).graphStore();
        Expression nodeFilter = NodeFilterParser.parseAndValidate(graphStore, procedureConfig.nodeFilter());
        NodeLabel nodeLabelToMutate = NodeLabel.of((String)nodeLabel);
        MutateLabelResult.Builder resultBuilder = MutateLabelResult.builder(graphName, nodeLabel).withConfig(procedureConfig.toMap());
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((MutateLabelResult.Builder)resultBuilder).withMutateMillis(arg_0));){
            NodesFilter.FilteredNodes filteredNodes = NodesFilter.filterNodes((GraphStore)graphStore, (Expression)nodeFilter, (int)procedureConfig.concurrency(), Map.of(), (ExecutorService)Pools.DEFAULT, (ProgressTracker)ProgressTracker.NULL_TRACKER);
            LongAdder nodeCounter = new LongAdder();
            IdMap idMap = filteredNodes.idMap();
            graphStore.addNodeLabel(nodeLabelToMutate);
            idMap.forEachNode(nodeId -> {
                long originalNodeId = idMap.toOriginalNodeId(nodeId);
                long mappedNodeId = graphStore.nodes().safeToMappedNodeId(originalNodeId);
                graphStore.nodes().addNodeIdToLabel(mappedNodeId, nodeLabelToMutate);
                nodeCounter.increment();
                return true;
            });
            resultBuilder.withNodeLabelsWritten(nodeCounter.longValue()).withNodeCount(graphStore.nodeCount());
        }
        return Stream.of(resultBuilder.build());
    }
}

