/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.filter.GraphStoreFilter;
import org.neo4j.gds.beta.filter.expression.SemanticErrors;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.config.GraphProjectFromGraphConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.mem.MemoryTree;
import org.neo4j.gds.core.utils.mem.MemoryTreeWithDimensions;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.executor.FictitiousGraphStoreLoader;
import org.neo4j.gds.executor.GraphStoreFromDatabaseLoader;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.utils.ExceptionUtil;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.opencypher.v9_0.parser.javacc.ParseException;

public class GraphProjectProc
extends CatalogProc {
    private static final String NO_GRAPH_NAME = "";
    private static final String DESCRIPTION = "Creates a named graph in the catalog for use by algorithms.";
    private static final Set<String> DISALLOWED_CONFIG_KEYS = Set.of("nodeProjection", "relationshipProjection", "nodeQuery", "relationshipQuery");

    @Procedure(name="gds.graph.project", mode=Mode.READ)
    @Description(value="Creates a named graph in the catalog for use by algorithms.")
    public Stream<GraphProjectNativeResult> project(@Name(value="graphName") String graphName, @Name(value="nodeProjection") @Nullable Object nodeProjection, @Name(value="relationshipProjection") @Nullable Object relationshipProjection, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        this.validateGraphName(this.username(), graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphProjectFromStoreConfig config = GraphProjectFromStoreConfig.of((String)this.username(), (String)graphName, (Object)nodeProjection, (Object)relationshipProjection, (CypherMapWrapper)cypherConfig);
        this.validateConfig(cypherConfig, (GraphProjectConfig)config);
        GraphProjectNativeResult result = (GraphProjectNativeResult)this.runWithExceptionLogging("Graph creation failed", () -> (GraphProjectNativeResult)this.projectGraph((GraphProjectConfig)config));
        return Stream.of(result);
    }

    @Procedure(name="gds.graph.project.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> projectEstimate(@Name(value="nodeProjection") @Nullable Object nodeProjection, @Name(value="relationshipProjection") @Nullable Object relationshipProjection, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphProjectFromStoreConfig config = GraphProjectFromStoreConfig.of((String)this.username(), (String)NO_GRAPH_NAME, (Object)nodeProjection, (Object)relationshipProjection, (CypherMapWrapper)cypherConfig);
        this.validateConfig(cypherConfig, (GraphProjectConfig)config);
        return this.estimateGraph((GraphProjectConfig)config);
    }

    @Procedure(name="gds.graph.project.cypher", mode=Mode.READ)
    @Description(value="Creates a named graph in the catalog for use by algorithms.")
    public Stream<GraphProjectCypherResult> projectCypher(@Name(value="graphName") String graphName, @Name(value="nodeQuery") String nodeQuery, @Name(value="relationshipQuery") String relationshipQuery, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        this.validateGraphName(this.username(), graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphProjectFromCypherConfig config = GraphProjectFromCypherConfig.of((String)this.username(), (String)graphName, (String)nodeQuery, (String)relationshipQuery, (CypherMapWrapper)cypherConfig);
        this.validateConfig(cypherConfig, (GraphProjectConfig)config);
        GraphProjectCypherResult result = (GraphProjectCypherResult)this.runWithExceptionLogging("Graph creation failed", () -> (GraphProjectCypherResult)this.projectGraph((GraphProjectConfig)config));
        return Stream.of(result);
    }

    @Procedure(name="gds.graph.project.cypher.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> projectCypherEstimate(@Name(value="nodeQuery") String nodeQuery, @Name(value="relationshipQuery") String relationshipQuery, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphProjectFromCypherConfig config = GraphProjectFromCypherConfig.of((String)this.username(), (String)NO_GRAPH_NAME, (String)nodeQuery, (String)relationshipQuery, (CypherMapWrapper)cypherConfig);
        this.validateConfig(cypherConfig, (GraphProjectConfig)config);
        return this.estimateGraph((GraphProjectConfig)config);
    }

    @Procedure(name="gds.beta.graph.project.subgraph", mode=Mode.READ)
    @Description(value="Creates a named graph in the catalog for use by algorithms.")
    public Stream<GraphProjectSubgraphResult> projectSubgraph(@Name(value="graphName") String graphName, @Name(value="fromGraphName") String fromGraphName, @Name(value="nodeFilter") String nodeFilter, @Name(value="relationshipFilter") String relationshipFilter, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        this.validateGraphName(this.username(), graphName);
        CypherMapWrapper procedureConfig = CypherMapWrapper.create(configuration);
        GraphStoreWithConfig fromGraphStore = this.graphStoreFromCatalog(fromGraphName);
        GraphProjectFromGraphConfig graphProjectConfig = GraphProjectFromGraphConfig.of((String)this.username(), (String)graphName, (String)fromGraphName, (String)nodeFilter, (String)relationshipFilter, (GraphProjectConfig)fromGraphStore.config(), (CypherMapWrapper)procedureConfig);
        this.validateConfig(procedureConfig, (GraphProjectConfig)graphProjectConfig);
        GraphProjectSubgraphResult result = (GraphProjectSubgraphResult)this.runWithExceptionLogging("Graph creation failed", ExceptionUtil.supplier(() -> this.projectGraphFromGraphStore(fromGraphStore.graphStore(), graphProjectConfig)));
        return Stream.of(result);
    }

    private GraphProjectSubgraphResult projectGraphFromGraphStore(GraphStore fromGraphStore, GraphProjectFromGraphConfig config) throws ParseException, SemanticErrors {
        ProgressTimer progressTimer = ProgressTimer.start();
        TaskProgressTracker progressTracker = new TaskProgressTracker(GraphStoreFilter.progressTask((GraphStore)fromGraphStore), this.log, config.concurrency(), config.jobId(), this.taskRegistryFactory, (UserLogRegistryFactory)EmptyUserLogRegistryFactory.INSTANCE);
        GraphStore graphStore = GraphStoreFilter.filter((GraphStore)fromGraphStore, (GraphProjectFromGraphConfig)config, (ExecutorService)Pools.DEFAULT, (ProgressTracker)progressTracker);
        GraphStoreCatalog.set((GraphProjectConfig)config, (GraphStore)graphStore);
        long projectMillis = progressTimer.stop().getDuration();
        return new GraphProjectSubgraphResult(config.graphName(), config.fromGraphName(), config.nodeFilter(), config.relationshipFilter(), graphStore.nodeCount(), graphStore.relationshipCount(), projectMillis);
    }

    private void validateConfig(CypherMapWrapper cypherConfig, GraphProjectConfig graphProjectConfig) {
        Collection allowedKeys = graphProjectConfig.isFictitiousLoading() ? graphProjectConfig.configKeys() : (Collection)graphProjectConfig.configKeys().stream().filter(key -> !DISALLOWED_CONFIG_KEYS.contains(key)).collect(Collectors.toList());
        this.validateConfig((CypherMapAccess)cypherConfig, allowedKeys);
    }

    private GraphProjectResult projectGraph(GraphProjectConfig config) {
        this.memoryUsageValidator().tryValidateMemoryUsage((BaseConfig)config, this::memoryTreeWithDimensions);
        GraphProjectResult.Builder builder = config instanceof GraphProjectFromCypherConfig ? new GraphProjectCypherResult.Builder((GraphProjectFromCypherConfig)config) : new GraphProjectNativeResult.Builder((GraphProjectFromStoreConfig)config);
        try (ProgressTimer ignored = ProgressTimer.start(builder::withProjectMillis);){
            GraphStore graphStore = new GraphStoreFromDatabaseLoader(config, this.username(), this.graphLoaderContext()).graphStore();
            builder.withNodeCount(graphStore.nodeCount()).withRelationshipCount(graphStore.relationshipCount());
            GraphStoreCatalog.set((GraphProjectConfig)config, (GraphStore)graphStore);
        }
        return builder.build();
    }

    private Stream<MemoryEstimateResult> estimateGraph(GraphProjectConfig config) {
        return Stream.of(new MemoryEstimateResult(this.memoryTreeWithDimensions(config)));
    }

    MemoryTreeWithDimensions memoryTreeWithDimensions(GraphProjectConfig config) {
        Object graphStoreCreator = config.isFictitiousLoading() ? new FictitiousGraphStoreLoader(config) : new GraphStoreFromDatabaseLoader(config, this.username(), this.graphLoaderContext());
        GraphDimensions graphDimensions = graphStoreCreator.graphDimensions();
        MemoryTree memoryTree = graphStoreCreator.estimateMemoryUsageDuringLoading().estimate(graphDimensions, config.readConcurrency());
        return new MemoryTreeWithDimensions(memoryTree, graphDimensions);
    }

    public static class GraphProjectSubgraphResult
    extends GraphProjectResult {
        public final String fromGraphName;
        public final String nodeFilter;
        public final String relationshipFilter;

        GraphProjectSubgraphResult(String graphName, String fromGraphName, String nodeFilter, String relationshipFilter, long nodeCount, long relationshipCount, long projectMillis) {
            super(graphName, nodeCount, relationshipCount, projectMillis);
            this.fromGraphName = fromGraphName;
            this.nodeFilter = nodeFilter;
            this.relationshipFilter = relationshipFilter;
        }
    }

    public static class GraphProjectCypherResult
    extends GraphProjectResult {
        public final String nodeQuery;
        public final String relationshipQuery;

        GraphProjectCypherResult(String graphName, String nodeQuery, String relationshipQuery, long nodeCount, long relationshipCount, long projectMillis) {
            super(graphName, nodeCount, relationshipCount, projectMillis);
            this.nodeQuery = nodeQuery;
            this.relationshipQuery = relationshipQuery;
        }

        protected static final class Builder
        extends GraphProjectResult.Builder {
            private final String nodeQuery;
            private final String relationshipQuery;

            Builder(GraphProjectFromCypherConfig config) {
                super((GraphProjectConfig)config);
                this.nodeQuery = config.nodeQuery();
                this.relationshipQuery = config.relationshipQuery();
            }

            @Override
            GraphProjectCypherResult build() {
                return new GraphProjectCypherResult(this.graphName, this.nodeQuery, this.relationshipQuery, this.nodeCount, this.relationshipCount, this.projectMillis);
            }
        }
    }

    public static class GraphProjectNativeResult
    extends GraphProjectResult {
        public final Map<String, Object> nodeProjection;
        public final Map<String, Object> relationshipProjection;

        GraphProjectNativeResult(String graphName, Map<String, Object> nodeProjection, Map<String, Object> relationshipProjection, long nodeCount, long relationshipCount, long projectMillis) {
            super(graphName, nodeCount, relationshipCount, projectMillis);
            this.nodeProjection = nodeProjection;
            this.relationshipProjection = relationshipProjection;
        }

        protected static final class Builder
        extends GraphProjectResult.Builder {
            private final NodeProjections nodeProjections;
            private final RelationshipProjections relationshipProjections;

            Builder(GraphProjectFromStoreConfig config) {
                super((GraphProjectConfig)config);
                this.nodeProjections = config.nodeProjections();
                this.relationshipProjections = config.relationshipProjections();
            }

            @Override
            GraphProjectNativeResult build() {
                return new GraphProjectNativeResult(this.graphName, this.nodeProjections.toObject(), this.relationshipProjections.toObject(), this.nodeCount, this.relationshipCount, this.projectMillis);
            }
        }
    }

    public static class GraphProjectResult {
        public final String graphName;
        public final long nodeCount;
        public final long relationshipCount;
        public final long projectMillis;

        GraphProjectResult(String graphName, long nodeCount, long relationshipCount, long projectMillis) {
            this.graphName = graphName;
            this.nodeCount = nodeCount;
            this.relationshipCount = relationshipCount;
            this.projectMillis = projectMillis;
        }

        protected static abstract class Builder {
            final String graphName;
            long nodeCount;
            long relationshipCount;
            long projectMillis;

            Builder(GraphProjectConfig config) {
                this.graphName = config.graphName();
            }

            Builder withNodeCount(long nodeCount) {
                this.nodeCount = nodeCount;
                return this;
            }

            Builder withRelationshipCount(long relationshipCount) {
                this.relationshipCount = relationshipCount;
                return this;
            }

            Builder withProjectMillis(long projectMillis) {
                this.projectMillis = projectMillis;
                return this;
            }

            abstract GraphProjectResult build();
        }
    }
}

