/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.catalog.GraphProjectProc;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphSampleAlgoConfig;
import org.neo4j.gds.config.RandomWalkWithRestartsProcConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.graphsampling.GraphSampleConstructor;
import org.neo4j.gds.graphsampling.NodesSampler;
import org.neo4j.gds.graphsampling.config.RandomWalkWithRestartsConfig;
import org.neo4j.gds.graphsampling.samplers.rwr.RandomWalkWithRestarts;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphSampleProc
extends CatalogProc {
    private static final String RWR_DESCRIPTION = "Constructs a random subgraph based on random walks with restarts";

    @Procedure(name="gds.alpha.graph.sample.rwr", mode=Mode.READ)
    @Description(value="Constructs a random subgraph based on random walks with restarts")
    public Stream<RandomWalkWithRestartsSampleResult> sampleRandomWalkWithRestarts(@Name(value="graphName") String graphName, @Name(value="fromGraphName") String fromGraphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        this.validateGraphName(this.username(), graphName);
        try (ProgressTimer progressTimer = ProgressTimer.start();){
            GraphStoreWithConfig fromGraphStore = this.graphStoreFromCatalog(fromGraphName);
            CypherMapWrapper cypherMap = CypherMapWrapper.create(configuration);
            RandomWalkWithRestartsConfig rwrConfig = RandomWalkWithRestartsConfig.of((CypherMapWrapper)cypherMap);
            RandomWalkWithRestarts randomWalkWithRestarts = new RandomWalkWithRestarts(rwrConfig);
            TaskProgressTracker progressTracker = new TaskProgressTracker(GraphSampleConstructor.progressTask((GraphStore)fromGraphStore.graphStore(), (NodesSampler)randomWalkWithRestarts), this.log, rwrConfig.concurrency(), rwrConfig.jobId(), this.taskRegistryFactory, (UserLogRegistryFactory)EmptyUserLogRegistryFactory.INSTANCE);
            GraphSampleConstructor graphSampleConstructor = new GraphSampleConstructor((GraphSampleAlgoConfig)rwrConfig, fromGraphStore.graphStore(), (NodesSampler)randomWalkWithRestarts, (ProgressTracker)progressTracker);
            GraphStore sampledGraphStore = graphSampleConstructor.compute();
            RandomWalkWithRestartsProcConfig rwrProcConfig = RandomWalkWithRestartsProcConfig.of(this.username(), graphName, fromGraphName, fromGraphStore.config(), cypherMap);
            GraphStoreCatalog.set((GraphProjectConfig)rwrProcConfig, (GraphStore)sampledGraphStore);
            long projectMillis = progressTimer.stop().getDuration();
            Stream<RandomWalkWithRestartsSampleResult> stream = Stream.of(new RandomWalkWithRestartsSampleResult(graphName, fromGraphName, sampledGraphStore.nodeCount(), sampledGraphStore.relationshipCount(), randomWalkWithRestarts.startNodesUsed().size(), projectMillis));
            return stream;
        }
    }

    public static class RandomWalkWithRestartsSampleResult
    extends GraphProjectProc.GraphProjectResult {
        public final String fromGraphName;
        public final long startNodeCount;

        RandomWalkWithRestartsSampleResult(String graphName, String fromGraphName, long nodeCount, long relationshipCount, long startNodeCount, long projectMillis) {
            super(graphName, nodeCount, relationshipCount, projectMillis);
            this.fromGraphName = fromGraphName;
            this.startNodeCount = startNodeCount;
        }
    }
}

