/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.GraphStoreToCsvEstimationConfig;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.io.GraphStoreExporter;
import org.neo4j.gds.core.io.GraphStoreExporterBaseConfig;
import org.neo4j.gds.core.io.NeoNodeProperties;
import org.neo4j.gds.core.io.db.GraphStoreToDatabaseExporter;
import org.neo4j.gds.core.io.db.GraphStoreToDatabaseExporterConfig;
import org.neo4j.gds.core.io.db.ProgressTrackerExecutionMonitor;
import org.neo4j.gds.core.io.file.GraphStoreExporterUtil;
import org.neo4j.gds.core.io.file.GraphStoreToFileExporterConfig;
import org.neo4j.gds.core.io.file.csv.estimation.CsvExportEstimation;
import org.neo4j.gds.core.utils.mem.MemoryTree;
import org.neo4j.gds.core.utils.mem.MemoryTreeWithDimensions;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.preconditions.ClusterRestrictions;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphStoreExportProc
extends BaseProc {
    @Procedure(name="gds.graph.export", mode=Mode.READ)
    @Description(value="Exports a named graph into a new offline Neo4j database.")
    public Stream<DatabaseExportResult> database(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ClusterRestrictions.disallowRunningOnCluster((GraphDatabaseService)this.databaseService, (String)"Export a graph to Neo4j database");
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphStoreToDatabaseExporterConfig exportConfig = GraphStoreToDatabaseExporterConfig.of((CypherMapWrapper)cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)exportConfig);
        DatabaseExportResult result = (DatabaseExportResult)this.runWithExceptionLogging("Graph creation failed", () -> {
            GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)exportConfig).graphStore();
            this.validateGraphStore(graphStore, (GraphStoreExporterBaseConfig)exportConfig);
            TaskProgressTracker progressTracker = new TaskProgressTracker(ProgressTrackerExecutionMonitor.progressTask((long)graphStore.nodeCount(), (long)graphStore.relationshipCount()), this.log, exportConfig.writeConcurrency(), exportConfig.jobId(), this.taskRegistryFactory, this.userLogRegistryFactory);
            GraphStoreToDatabaseExporter exporter = GraphStoreToDatabaseExporter.of((GraphStore)graphStore, (GraphDatabaseService)this.databaseService, (GraphStoreToDatabaseExporterConfig)exportConfig, this.neoNodeProperties((GraphStoreExporterBaseConfig)exportConfig, graphStore), (Log)this.log, (ProgressTracker)progressTracker);
            long start = System.nanoTime();
            GraphStoreExporter.ExportedProperties exportedProperties = exporter.run();
            long end = System.nanoTime();
            return new DatabaseExportResult(graphName, exportConfig.dbName(), graphStore.nodeCount(), graphStore.relationshipCount(), graphStore.relationshipTypes().size(), exportedProperties.nodePropertyCount(), exportedProperties.relationshipPropertyCount(), TimeUnit.NANOSECONDS.toMillis(end - start));
        });
        return Stream.of(result);
    }

    @Procedure(name="gds.beta.graph.export.csv", mode=Mode.READ)
    @Description(value="Exports a named graph to CSV files.")
    public Stream<FileExportResult> csv(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphStoreToFileExporterConfig exportConfig = GraphStoreToFileExporterConfig.of((String)this.username(), (CypherMapWrapper)cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)exportConfig);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)exportConfig).graphStore();
        this.validateGraphStore(graphStore, (GraphStoreExporterBaseConfig)exportConfig);
        Config neo4jConfig = (Config)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.databaseService, Config.class);
        GraphStoreExporterUtil.ExportToCsvResult result = GraphStoreExporterUtil.export((GraphStore)graphStore, (Path)GraphStoreExporterUtil.exportLocation((Configuration)neo4jConfig, (GraphStoreToFileExporterConfig)exportConfig), (GraphStoreToFileExporterConfig)exportConfig, this.neoNodeProperties((GraphStoreExporterBaseConfig)exportConfig, graphStore), (TaskRegistryFactory)this.taskRegistryFactory, (Log)this.log);
        return Stream.of(new FileExportResult(graphName, exportConfig.exportName(), graphStore.nodeCount(), graphStore.relationshipCount(), graphStore.relationshipTypes().size(), result.importedProperties().nodePropertyCount(), result.importedProperties().relationshipPropertyCount(), result.tookMillis()));
    }

    @Procedure(name="gds.beta.graph.export.csv.estimate", mode=Mode.READ)
    @Description(value="Estimate the required disk space for exporting a named graph to CSV files.")
    public Stream<MemoryEstimateResult> csvEstimate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphStoreToCsvEstimationConfig exportConfig = GraphStoreToCsvEstimationConfig.of(this.username(), cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)exportConfig);
        MemoryTreeWithDimensions estimate = (MemoryTreeWithDimensions)this.runWithExceptionLogging("CSV export estimation failed", () -> {
            GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)exportConfig).graphStore();
            GraphDimensions dimensions = GraphDimensions.of((long)graphStore.nodeCount(), (long)graphStore.relationshipCount());
            MemoryTree memoryTree = CsvExportEstimation.estimate((GraphStore)graphStore, (double)exportConfig.samplingFactor()).estimate(dimensions, 1);
            return new MemoryTreeWithDimensions(memoryTree, dimensions);
        });
        return Stream.of(new MemoryEstimateResult(estimate));
    }

    private Optional<NeoNodeProperties> neoNodeProperties(GraphStoreExporterBaseConfig exportConfig, GraphStore graphStore) {
        return NeoNodeProperties.of((GraphStore)graphStore, (TransactionContext)TransactionContext.of((GraphDatabaseService)this.databaseService, (Transaction)this.procedureTransaction), (PropertyMappings)exportConfig.additionalNodeProperties(), (Log)this.log);
    }

    private void validateGraphStore(GraphStore graphStore, GraphStoreExporterBaseConfig exportConfig) {
        this.validateReadAccess(graphStore, !exportConfig.additionalNodeProperties().mappings().isEmpty());
        this.validateAdditionalNodeProperties(graphStore, exportConfig.additionalNodeProperties());
    }

    private void validateReadAccess(GraphStore graphStore, boolean exportAdditionalNodeProperties) {
        if (exportAdditionalNodeProperties && !graphStore.capabilities().canWriteToDatabase()) {
            throw new IllegalArgumentException("Exporting additional node properties is not allowed for this graph.");
        }
    }

    private void validateAdditionalNodeProperties(GraphStore graphStore, PropertyMappings additionalNodeProperties) {
        Set nodeProperties = graphStore.nodePropertyKeys();
        List duplicateProperties = additionalNodeProperties.stream().map(PropertyMapping::neoPropertyKey).filter(nodeProperties::contains).collect(Collectors.toList());
        if (!duplicateProperties.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The following provided additional node properties are already present in the in-memory graph: %s", (Object[])new Object[]{StringJoining.joinVerbose(duplicateProperties)}));
        }
    }

    public static class FileExportResult
    extends GraphStoreExportResult {
        public final String exportName;

        public FileExportResult(String graphName, String exportName, long nodeCount, long relationshipCount, long relationshipTypeCount, long nodePropertyCount, long relationshipPropertyCount, long writeMillis) {
            super(graphName, nodeCount, relationshipCount, relationshipTypeCount, nodePropertyCount, relationshipPropertyCount, writeMillis);
            this.exportName = exportName;
        }
    }

    public static class DatabaseExportResult
    extends GraphStoreExportResult {
        public final String dbName;

        public DatabaseExportResult(String graphName, String dbName, long nodeCount, long relationshipCount, long relationshipTypeCount, long nodePropertyCount, long relationshipPropertyCount, long writeMillis) {
            super(graphName, nodeCount, relationshipCount, relationshipTypeCount, nodePropertyCount, relationshipPropertyCount, writeMillis);
            this.dbName = dbName;
        }
    }

    public static abstract class GraphStoreExportResult {
        public final String graphName;
        public final long nodeCount;
        public final long relationshipCount;
        public final long relationshipTypeCount;
        public final long nodePropertyCount;
        public final long relationshipPropertyCount;
        public final long writeMillis;

        public GraphStoreExportResult(String graphName, long nodeCount, long relationshipCount, long relationshipTypeCount, long nodePropertyCount, long relationshipPropertyCount, long writeMillis) {
            this.graphName = graphName;
            this.nodeCount = nodeCount;
            this.relationshipCount = relationshipCount;
            this.relationshipTypeCount = relationshipTypeCount;
            this.nodePropertyCount = nodePropertyCount;
            this.relationshipPropertyCount = relationshipPropertyCount;
            this.writeMillis = writeMillis;
        }
    }
}

