/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.catalog.GraphStoreToCsvEstimationConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;

public final class GraphStoreToCsvEstimationConfigImpl
implements GraphStoreToCsvEstimationConfig {
    private double samplingFactor;
    private String username;
    private String exportName;
    private String defaultRelationshipType;
    private int writeConcurrency;
    private int batchSize;
    private PropertyMappings additionalNodeProperties;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;

    public GraphStoreToCsvEstimationConfigImpl(@NotNull String username, @NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.samplingFactor = config.getDouble("samplingFactor", GraphStoreToCsvEstimationConfig.super.samplingFactor());
            CypherMapAccess.validateDoubleRange((String)"samplingFactor", (double)this.samplingFactor, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapAccess.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.exportName = (String)CypherMapAccess.failOnNull((String)"exportName", (Object)config.requireString("exportName"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.defaultRelationshipType = (String)CypherMapAccess.failOnNull((String)"defaultRelationshipType", (Object)config.getString("defaultRelationshipType", GraphStoreToCsvEstimationConfig.super.defaultRelationshipType()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", GraphStoreToCsvEstimationConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.batchSize = config.getInt("batchSize", GraphStoreToCsvEstimationConfig.super.batchSize());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.additionalNodeProperties = (PropertyMappings)CypherMapAccess.failOnNull((String)"additionalNodeProperties", (Object)PropertyMappings.fromObject((Object)config.getChecked("additionalNodeProperties", (Object)GraphStoreToCsvEstimationConfig.super.additionalNodeProperties(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphStoreToCsvEstimationConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", GraphStoreToCsvEstimationConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double samplingFactor() {
        return this.samplingFactor;
    }

    public String username() {
        return this.username;
    }

    public String exportName() {
        return this.exportName;
    }

    public String defaultRelationshipType() {
        return this.defaultRelationshipType;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public PropertyMappings additionalNodeProperties() {
        return this.additionalNodeProperties;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("samplingFactor", "exportName", "defaultRelationshipType", "writeConcurrency", "batchSize", "additionalNodeProperties", "username", "sudo", "logProgress");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("samplingFactor", this.samplingFactor());
        map.put("exportName", this.exportName());
        map.put("defaultRelationshipType", this.defaultRelationshipType());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("batchSize", this.batchSize());
        map.put("additionalNodeProperties", PropertyMappings.toObject((PropertyMappings)this.additionalNodeProperties()));
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;

        public static Builder from(GraphStoreToCsvEstimationConfig baseConfig) {
            Builder builder = new Builder();
            builder.samplingFactor(baseConfig.samplingFactor());
            builder.username(baseConfig.username());
            builder.exportName(baseConfig.exportName());
            builder.defaultRelationshipType(baseConfig.defaultRelationshipType());
            builder.writeConcurrency(baseConfig.writeConcurrency());
            builder.batchSize(baseConfig.batchSize());
            builder.additionalNodeProperties(baseConfig.additionalNodeProperties());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            return builder;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder samplingFactor(double samplingFactor) {
            this.config.put("samplingFactor", samplingFactor);
            return this;
        }

        public Builder exportName(String exportName) {
            this.config.put("exportName", exportName);
            return this;
        }

        public Builder defaultRelationshipType(String defaultRelationshipType) {
            this.config.put("defaultRelationshipType", defaultRelationshipType);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.config.put("batchSize", batchSize);
            return this;
        }

        public Builder additionalNodeProperties(Object additionalNodeProperties) {
            this.config.put("additionalNodeProperties", additionalNodeProperties);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public GraphStoreToCsvEstimationConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphStoreToCsvEstimationConfigImpl(this.username, (CypherMapAccess)config);
        }
    }
}

