/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphAccessGraphPropertiesConfig;
import org.neo4j.gds.config.GraphStreamGraphPropertiesConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphStreamGraphPropertiesProc
extends CatalogProc {
    @Procedure(name="gds.alpha.graph.graphProperty.stream", mode=Mode.READ)
    @Description(value="Streams the given graph property.")
    public Stream<PropertyResult> streamProperty(@Name(value="graphName") String graphName, @Name(value="graphProperty") String graphProperty, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphStreamGraphPropertiesConfig config = GraphStreamGraphPropertiesConfig.of((String)graphName, (String)graphProperty, (CypherMapWrapper)cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)config).graphStore();
        config.validate(graphStore);
        return this.streamGraphProperties(graphStore, (GraphAccessGraphPropertiesConfig)config);
    }

    private Stream<PropertyResult> streamGraphProperties(GraphStore graphStore, GraphAccessGraphPropertiesConfig config) {
        return graphStore.graphPropertyValues(config.graphProperty()).objects().map(PropertyResult::new);
    }

    public static class PropertyResult {
        public final Object propertyValue;

        PropertyResult(Object propertyValue) {
            this.propertyValue = propertyValue;
        }
    }
}

