/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.GraphStreamNodePropertiesConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.kernel.api.Statement;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphStreamNodePropertiesProc
extends CatalogProc {
    @Procedure(name="gds.graph.nodeProperties.stream", mode=Mode.READ)
    @Description(value="Streams the given node properties.")
    public Stream<PropertiesResult> streamNodeProperties(@Name(value="graphName") String graphName, @Name(value="nodeProperties") Object nodeProperties, @Name(value="nodeLabels", defaultValue="['*']") Object nodeLabels, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.streamNodeProperties(graphName, configuration, nodeProperties, nodeLabels, PropertiesResult::new);
    }

    @Procedure(name="gds.graph.streamNodeProperties", mode=Mode.READ, deprecatedBy="gds.graph.nodeProperties.stream")
    @Description(value="Streams the given node properties.")
    public Stream<PropertiesResult> streamProperties(@Name(value="graphName") String graphName, @Name(value="nodeProperties") Object nodeProperties, @Name(value="nodeLabels", defaultValue="['*']") Object nodeLabels, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.nodeProperties.stream`";
        return this.streamNodeProperties(graphName, configuration, nodeProperties, nodeLabels, PropertiesResult::new, Optional.of(deprecationWarning));
    }

    @Procedure(name="gds.graph.nodeProperty.stream", mode=Mode.READ)
    @Description(value="Streams the given node property.")
    public Stream<PropertyResult> streamNodeProperty(@Name(value="graphName") String graphName, @Name(value="nodeProperties") String nodeProperty, @Name(value="nodeLabels", defaultValue="['*']") Object nodeLabels, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.streamNodeProperties(graphName, configuration, List.of(nodeProperty), nodeLabels, (nodeId, propertyName, propertyValue) -> new PropertyResult(nodeId, propertyValue));
    }

    @Procedure(name="gds.graph.streamNodeProperty", mode=Mode.READ, deprecatedBy="gds.graph.nodeProperty.stream")
    @Description(value="Streams the given node property.")
    public Stream<PropertyResult> streamProperty(@Name(value="graphName") String graphName, @Name(value="nodeProperties") String nodeProperty, @Name(value="nodeLabels", defaultValue="['*']") Object nodeLabels, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.nodeProperty.stream`";
        return this.streamNodeProperties(graphName, configuration, List.of(nodeProperty), nodeLabels, (nodeId, propertyName, propertyValue) -> new PropertyResult(nodeId, propertyValue), Optional.of(deprecationWarning));
    }

    private <R> Stream<R> streamNodeProperties(String graphName, Map<String, Object> configuration, Object nodeProperties, Object nodeLabels, ResultProducer<R> producer) {
        return this.streamNodeProperties(graphName, configuration, nodeProperties, nodeLabels, producer, Optional.empty());
    }

    private <R> Stream<R> streamNodeProperties(String graphName, Map<String, Object> configuration, Object nodeProperties, Object nodeLabels, ResultProducer<R> producer, Optional<String> deprecationWarning) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphStreamNodePropertiesConfig config = GraphStreamNodePropertiesConfig.of(graphName, nodeProperties, nodeLabels, cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, config).graphStore();
        config.validate(graphStore);
        Collection<NodeLabel> validNodeLabels = config.validNodeLabels(graphStore);
        Graph subGraph = graphStore.getGraph(validNodeLabels, (Collection)graphStore.relationshipTypes(), Optional.empty());
        List nodePropertyKeysAndValues = config.nodeProperties().stream().map(propertyKey -> Pair.of((Object)propertyKey, (Object)subGraph.nodeProperties(propertyKey))).collect(Collectors.toList());
        boolean usesPropertyNameColumn = this.callContext.outputFields().anyMatch(field -> field.equals("nodeProperty"));
        LeafTask task = Tasks.leaf((String)"Graph :: NodeProperties :: Stream", (long)(subGraph.nodeCount() * (long)nodePropertyKeysAndValues.size()));
        TaskProgressTracker taskProgressTracker = new TaskProgressTracker((Task)task, this.log, config.concurrency(), new JobId(), this.taskRegistryFactory, this.userLogRegistryFactory);
        taskProgressTracker.beginSubTask();
        deprecationWarning.ifPresent(arg_0 -> ((TaskProgressTracker)taskProgressTracker).logWarning(arg_0));
        Stream resultStream = (Stream)LongStream.range(0L, subGraph.nodeCount()).boxed().flatMap(nodeId -> {
            long originalId = subGraph.toOriginalNodeId(nodeId.longValue());
            return nodePropertyKeysAndValues.stream().map(propertyKeyAndValues -> {
                taskProgressTracker.logProgress();
                return producer.produce(originalId, usesPropertyNameColumn ? (String)propertyKeyAndValues.getKey() : null, ((NodePropertyValues)propertyKeyAndValues.getValue()).getObject(nodeId.longValue()));
            });
        }).onClose(() -> ((TaskProgressTracker)taskProgressTracker).endSubTask());
        try (Statement statement = this.transaction.acquireStatement();){
            statement.registerCloseableResource((AutoCloseable)resultStream);
            Stream stream = resultStream;
            return stream;
        }
    }

    static interface ResultProducer<R> {
        public R produce(long var1, String var3, Object var4);
    }

    public static class PropertyResult {
        public final long nodeId;
        public final Object propertyValue;

        PropertyResult(long nodeId, Object propertyValue) {
            this.nodeId = nodeId;
            this.propertyValue = propertyValue;
        }
    }

    public static class PropertiesResult {
        public final long nodeId;
        public final String nodeProperty;
        public final Object propertyValue;

        PropertiesResult(long nodeId, String nodeProperty, Object propertyValue) {
            this.nodeId = nodeId;
            this.nodeProperty = nodeProperty;
            this.propertyValue = propertyValue;
        }
    }
}

