/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphStreamRelationshipPropertiesConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.kernel.api.Statement;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphStreamRelationshipPropertiesProc
extends CatalogProc {
    @Procedure(name="gds.graph.relationshipProperties.stream", mode=Mode.READ)
    @Description(value="Streams the given relationship properties.")
    public Stream<PropertiesResult> streamRelationshipProperties(@Name(value="graphName") String graphName, @Name(value="relationshipProperties") List<String> relationshipProperties, @Name(value="relationshipTypes", defaultValue="['*']") List<String> relationshipTypes, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.streamRelationshipProperties(graphName, configuration, relationshipProperties, relationshipTypes, PropertiesResult::new, Optional.empty());
    }

    @Procedure(name="gds.graph.streamRelationshipProperties", mode=Mode.READ, deprecatedBy="gds.graph.relationshipProperties.stream")
    @Description(value="Streams the given relationship properties.")
    public Stream<PropertiesResult> streamProperties(@Name(value="graphName") String graphName, @Name(value="relationshipProperties") List<String> relationshipProperties, @Name(value="relationshipTypes", defaultValue="['*']") List<String> relationshipTypes, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.relationshipProperties.stream`";
        return this.streamRelationshipProperties(graphName, configuration, relationshipProperties, relationshipTypes, PropertiesResult::new, Optional.of(deprecationWarning));
    }

    @Procedure(name="gds.graph.relationshipProperty.stream", mode=Mode.READ)
    @Description(value="Streams the given relationship property.")
    public Stream<PropertyResult> streamRelationshipProperty(@Name(value="graphName") String graphName, @Name(value="relationshipProperty") String relationshipProperty, @Name(value="relationshipTypes", defaultValue="['*']") List<String> relationshipTypes, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.streamRelationshipProperties(graphName, configuration, List.of(relationshipProperty), relationshipTypes, (sourceId, targetId, relationshipType, propertyName, propertyValue) -> new PropertyResult(sourceId, targetId, relationshipType, propertyValue), Optional.empty());
    }

    @Procedure(name="gds.graph.streamRelationshipProperty", mode=Mode.READ, deprecatedBy="gds.graph.relationshipProperty.stream")
    @Description(value="Streams the given relationship property.")
    public Stream<PropertyResult> streamProperty(@Name(value="graphName") String graphName, @Name(value="relationshipProperties") String relationshipProperty, @Name(value="relationshipTypes", defaultValue="['*']") List<String> relationshipTypes, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.relationshipProperty.stream`";
        return this.streamRelationshipProperties(graphName, configuration, List.of(relationshipProperty), relationshipTypes, (sourceId, targetId, relationshipType, propertyName, propertyValue) -> new PropertyResult(sourceId, targetId, relationshipType, propertyValue), Optional.of(deprecationWarning));
    }

    private <R> Stream<R> streamRelationshipProperties(String graphName, Map<String, Object> configuration, List<String> relationshipProperties, List<String> relationshipTypes, ResultProducer<R> producer, Optional<String> deprecationWarning) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphStreamRelationshipPropertiesConfig config = GraphStreamRelationshipPropertiesConfig.of((String)graphName, relationshipProperties, relationshipTypes, (CypherMapWrapper)cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)config).graphStore();
        config.validate(graphStore);
        Collection validRelationshipTypes = config.validRelationshipTypes(graphStore);
        List relationshipPropertyKeysAndValues = validRelationshipTypes.stream().flatMap(relType -> config.relationshipProperties().stream().filter(propertyKey -> graphStore.hasRelationshipProperty(relType, propertyKey)).map(propertyKey -> Triple.of((Object)relType, (Object)propertyKey, (Object)graphStore.getGraph(relType, Optional.of(propertyKey))))).collect(Collectors.toList());
        boolean usesPropertyNameColumn = this.callContext.outputFields().anyMatch(field -> field.equals("relationshipProperty"));
        LeafTask task = Tasks.leaf((String)"Graph :: RelationshipProperties :: Stream", (long)(graphStore.nodeCount() * (long)relationshipPropertyKeysAndValues.size()));
        TaskProgressTracker taskProgressTracker = new TaskProgressTracker((Task)task, this.log, config.concurrency(), new JobId(), this.taskRegistryFactory, this.userLogRegistryFactory);
        taskProgressTracker.beginSubTask();
        deprecationWarning.ifPresent(arg_0 -> ((TaskProgressTracker)taskProgressTracker).logWarning(arg_0));
        Stream resultStream = (Stream)LongStream.range(0L, graphStore.nodeCount()).mapToObj(nodeId -> relationshipPropertyKeysAndValues.stream().flatMap(relTypeAndPropertyKeyAndValues -> {
            ValueType valueType = graphStore.relationshipPropertyType((String)relTypeAndPropertyKeyAndValues.getMiddle());
            DoubleFunction<Number> convertProperty = valueType == ValueType.DOUBLE ? property -> property : property -> (long)property;
            String relationshipType = ((RelationshipType)relTypeAndPropertyKeyAndValues.getLeft()).name();
            String propertyName = usesPropertyNameColumn ? (String)relTypeAndPropertyKeyAndValues.getMiddle() : null;
            Graph graph = (Graph)relTypeAndPropertyKeyAndValues.getRight();
            long originalSourceId = graph.toOriginalNodeId(nodeId);
            return graph.streamRelationships(nodeId, Double.NaN).map(relationshipCursor -> {
                long originalTargetId = graph.toOriginalNodeId(relationshipCursor.targetId());
                Number propertyValue = (Number)convertProperty.apply(relationshipCursor.property());
                return producer.produce(originalSourceId, originalTargetId, relationshipType, propertyName, propertyValue);
            });
        })).flatMap(Function.identity()).onClose(() -> ((TaskProgressTracker)taskProgressTracker).endSubTask());
        try (Statement statement = this.transaction.acquireStatement();){
            statement.registerCloseableResource((AutoCloseable)resultStream);
            Stream stream = resultStream;
            return stream;
        }
    }

    static interface ResultProducer<R> {
        public R produce(long var1, long var3, String var5, @Nullable String var6, Number var7);
    }

    public static class PropertyResult {
        public final long sourceNodeId;
        public final long targetNodeId;
        public final String relationshipType;
        public final Number propertyValue;

        PropertyResult(long sourceNodeId, long targetNodeId, String relationshipType, Number propertyValue) {
            this.sourceNodeId = sourceNodeId;
            this.targetNodeId = targetNodeId;
            this.relationshipType = relationshipType;
            this.propertyValue = propertyValue;
        }
    }

    public static class PropertiesResult {
        public final long sourceNodeId;
        public final long targetNodeId;
        public final String relationshipType;
        public final String relationshipProperty;
        public final Number propertyValue;

        PropertiesResult(long sourceNodeId, long targetNodeId, String relationshipType, String relationshipProperty, Number propertyValue) {
            this.sourceNodeId = sourceNodeId;
            this.targetNodeId = targetNodeId;
            this.relationshipType = relationshipType;
            this.relationshipProperty = relationshipProperty;
            this.propertyValue = propertyValue;
        }
    }
}

