/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.eclipse.collections.impl.tuple.Tuples;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphStreamRelationshipsConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphStreamRelationshipsProc
extends CatalogProc {
    @Procedure(name="gds.beta.graph.relationships.stream", mode=Mode.READ)
    @Description(value="Streams the given relationship source/target pairs")
    public Stream<TopologyResult> streamRelationships(@Name(value="graphName") String graphName, @Name(value="relationshipTypes", defaultValue="['*']") List<String> relationshipTypes, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(configuration);
        GraphStreamRelationshipsConfig config = GraphStreamRelationshipsConfig.of((String)graphName, relationshipTypes, (CypherMapWrapper)cypherMapWrapper);
        this.validateConfig((CypherMapAccess)cypherMapWrapper, (BaseConfig)config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)config).graphStore();
        config.validate(graphStore);
        return GraphStreamRelationshipsProc.streamRelationshipTopology(graphStore, config);
    }

    private static Stream<TopologyResult> streamRelationshipTopology(GraphStore graphStore, GraphStreamRelationshipsConfig config) {
        List relationshipTypesAndGraphs = config.relationshipTypeIdentifiers(graphStore).stream().map(relationshipType -> Tuples.pair((Object)relationshipType.name(), (Object)graphStore.getGraph(new RelationshipType[]{relationshipType}))).collect(Collectors.toList());
        return (Stream)ParallelUtil.parallelStream((BaseStream)LongStream.range(0L, graphStore.nodeCount()), (int)config.concurrency(), nodeStream -> nodeStream.boxed().flatMap(nodeId -> relationshipTypesAndGraphs.stream().flatMap(graphAndRelationshipType -> {
            String relationshipType = (String)graphAndRelationshipType.getOne();
            Graph graph = (Graph)graphAndRelationshipType.getTwo();
            long originalSourceId = graph.toOriginalNodeId(nodeId.longValue());
            return graph.streamRelationships(nodeId.longValue(), Double.NaN).map(relationshipCursor -> new TopologyResult(originalSourceId, graph.toOriginalNodeId(relationshipCursor.targetId()), relationshipType));
        })));
    }

    public static class TopologyResult {
        public final long sourceNodeId;
        public final long targetNodeId;
        public final String relationshipType;

        public TopologyResult(long sourceNodeId, long targetNodeId, String relationshipType) {
            this.sourceNodeId = sourceNodeId;
            this.targetNodeId = targetNodeId;
            this.relationshipType = relationshipType;
        }

        public String toString() {
            return StringFormatting.formatWithLocale((String)"TopologyResult(%d, %d, type: %s)", (Object[])new Object[]{this.sourceNodeId, this.targetNodeId, this.relationshipType});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopologyResult that = (TopologyResult)o;
            return this.sourceNodeId == that.sourceNodeId && this.targetNodeId == that.targetNodeId && this.relationshipType.equals(that.relationshipType);
        }

        public int hashCode() {
            return Objects.hash(this.sourceNodeId, this.targetNodeId, this.relationshipType);
        }
    }
}

