/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.filter.NodesFilter;
import org.neo4j.gds.beta.filter.expression.Expression;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.catalog.NodeFilterParser;
import org.neo4j.gds.catalog.WriteLabelResult;
import org.neo4j.gds.config.WriteLabelConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.write.NodeLabelExporter;
import org.neo4j.gds.core.write.NodeLabelExporterBuilder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.opencypher.v9_0.parser.javacc.ParseException;

public class GraphWriteNodeLabelProc
extends CatalogProc {
    @Context
    public NodeLabelExporterBuilder<? extends NodeLabelExporter> nodeLabelExporterBuilder;

    @Procedure(name="gds.alpha.graph.nodeLabel.write", mode=Mode.WRITE)
    @Description(value="Writes the given node Label to an online Neo4j database.")
    public Stream<WriteLabelResult> write(@Name(value="graphName") String graphName, @Name(value="nodeLabel") String nodeLabel, @Name(value="configuration") Map<String, Object> configuration) throws ParseException {
        ProcPreconditions.check();
        WriteLabelConfig procedureConfig = WriteLabelConfig.of(configuration);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName).graphStore();
        Expression nodeFilter = NodeFilterParser.parseAndValidate(graphStore, procedureConfig.nodeFilter());
        WriteLabelResult.Builder resultBuilder = WriteLabelResult.builder(graphName, nodeLabel).withConfig(procedureConfig.toMap());
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((WriteLabelResult.Builder)resultBuilder).withWriteMillis(arg_0));){
            NodesFilter.FilteredNodes filteredNodes = NodesFilter.filterNodes((GraphStore)graphStore, (Expression)nodeFilter, (int)procedureConfig.concurrency(), Map.of(), (ExecutorService)Pools.DEFAULT, (ProgressTracker)ProgressTracker.NULL_TRACKER);
            NodeLabelExporter nodeLabelExporter = this.nodeLabelExporterBuilder.withIdMap(filteredNodes.idMap()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction)).parallel(Pools.DEFAULT, procedureConfig.concurrency()).build();
            this.runWithExceptionLogging("Node label writing failed", () -> nodeLabelExporter.write(nodeLabel));
            resultBuilder.withNodeLabelsWritten(nodeLabelExporter.nodeLabelsWritten()).withNodeCount(graphStore.nodeCount());
        }
        return Stream.of(resultBuilder.build());
    }
}

