/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.GraphWriteNodePropertiesConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.tasks.IterativeTask;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphWriteNodePropertiesProc
extends CatalogProc {
    @Context
    public NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder;

    @Procedure(name="gds.graph.nodeProperties.write", mode=Mode.WRITE)
    @Description(value="Writes the given node properties to an online Neo4j database.")
    public Stream<Result> writeNodeProperties(@Name(value="graphName") String graphName, @Name(value="nodeProperties") Object nodeProperties, @Name(value="nodeLabels", defaultValue="['*']") Object nodeLabels, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.writeNodeProperties(graphName, nodeProperties, nodeLabels, configuration, Optional.empty());
    }

    @Procedure(name="gds.graph.writeNodeProperties", mode=Mode.WRITE, deprecatedBy="gds.graph.nodeProperties.write")
    @Description(value="Writes the given node properties to an online Neo4j database.")
    public Stream<Result> run(@Name(value="graphName") String graphName, @Name(value="nodeProperties") Object nodeProperties, @Name(value="nodeLabels", defaultValue="['*']") Object nodeLabels, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.nodeProperties.write`";
        return this.writeNodeProperties(graphName, nodeProperties, nodeLabels, configuration, Optional.of(deprecationWarning));
    }

    private Stream<Result> writeNodeProperties(String graphName, Object nodeProperties, Object nodeLabels, Map<String, Object> configuration, Optional<String> deprecationWarning) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphWriteNodePropertiesConfig config = GraphWriteNodePropertiesConfig.of(graphName, nodeProperties, nodeLabels, cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, config).graphStore();
        config.validate(graphStore);
        Collection<NodeLabel> validNodeLabels = config.validNodeLabels(graphStore);
        IterativeTask task = Tasks.iterativeFixed((String)"Graph :: NodeProperties :: Write", () -> List.of(NodePropertyExporter.innerTask((String)"Label", (long)-1L)), (int)validNodeLabels.size());
        TaskProgressTracker progressTracker = new TaskProgressTracker((Task)task, this.log, config.writeConcurrency(), new JobId(), this.taskRegistryFactory, this.userLogRegistryFactory);
        deprecationWarning.ifPresent(arg_0 -> ((TaskProgressTracker)progressTracker).logWarning(arg_0));
        Result.Builder builder = new Result.Builder(graphName, config.nodeProperties());
        try (ProgressTimer ignored = ProgressTimer.start(builder::withWriteMillis);){
            long propertiesWritten = (Long)this.runWithExceptionLogging("Node property writing failed", () -> this.writeNodeProperties(graphStore, config, validNodeLabels, (ProgressTracker)progressTracker));
            builder.withPropertiesWritten(propertiesWritten);
        }
        return Stream.of(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeNodeProperties(GraphStore graphStore, GraphWriteNodePropertiesConfig config, Iterable<NodeLabel> validNodeLabels, ProgressTracker progressTracker) {
        long propertiesWritten = 0L;
        progressTracker.beginSubTask();
        try {
            for (NodeLabel label : validNodeLabels) {
                Graph subGraph = graphStore.getGraph(Collections.singletonList(label), (Collection)graphStore.relationshipTypes(), Optional.empty());
                NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMap((IdMap)subGraph).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction)).parallel(Pools.DEFAULT, config.writeConcurrency()).withProgressTracker(progressTracker).build();
                List writeNodeProperties = config.nodeProperties().stream().map(nodePropertyKey -> ImmutableNodeProperty.of((String)nodePropertyKey, (NodePropertyValues)subGraph.nodeProperties(nodePropertyKey))).collect(Collectors.toList());
                exporter.write(writeNodeProperties);
                propertiesWritten += exporter.propertiesWritten();
            }
        }
        finally {
            progressTracker.endSubTask();
        }
        return propertiesWritten;
    }

    public static class Result {
        public final long writeMillis;
        public final String graphName;
        public final List<String> nodeProperties;
        public final long propertiesWritten;

        Result(long writeMillis, String graphName, List<String> nodeProperties, long propertiesWritten) {
            this.writeMillis = writeMillis;
            this.graphName = graphName;
            this.nodeProperties = nodeProperties.stream().sorted().collect(Collectors.toList());
            this.propertiesWritten = propertiesWritten;
        }

        static class Builder {
            private final String graphName;
            private final List<String> nodeProperties;
            private long propertiesWritten;
            private long writeMillis;

            Builder(String graphName, List<String> nodeProperties) {
                this.graphName = graphName;
                this.nodeProperties = nodeProperties;
            }

            Builder withWriteMillis(long writeMillis) {
                this.writeMillis = writeMillis;
                return this;
            }

            Builder withPropertiesWritten(long propertiesWritten) {
                this.propertiesWritten = propertiesWritten;
                return this;
            }

            Result build() {
                return new Result(this.writeMillis, this.graphName, this.nodeProperties, this.propertiesWritten);
            }
        }
    }
}

