/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ProcPreconditions;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphWriteRelationshipConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.Values;

public class GraphWriteRelationshipProc
extends CatalogProc {
    @Context
    public RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder;

    @Procedure(name="gds.graph.relationship.write", mode=Mode.WRITE)
    @Description(value="Writes the given relationship and an optional relationship property to an online Neo4j database.")
    public Stream<Result> writeRelationships(@Name(value="graphName") String graphName, @Name(value="relationshipType") String relationshipType, @Name(value="relationshipProperty", defaultValue="") @Nullable String relationshipProperty, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.writeRelationships(graphName, relationshipType, relationshipProperty, configuration, Optional.empty());
    }

    @Procedure(name="gds.graph.writeRelationship", mode=Mode.WRITE, deprecatedBy="gds.graph.relationships.write")
    @Description(value="Writes the given relationship and an optional relationship property to an online Neo4j database.")
    public Stream<Result> run(@Name(value="graphName") String graphName, @Name(value="relationshipType") String relationshipType, @Name(value="relationshipProperty", defaultValue="") @Nullable String relationshipProperty, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        String deprecationWarning = "This procedures is deprecated for removal. Please use `gds.graph.relationship.write`";
        return this.writeRelationships(graphName, relationshipType, relationshipProperty, configuration, Optional.of(deprecationWarning));
    }

    private Stream<Result> writeRelationships(String graphName, String relationshipTypeString, String relationshipProperty, Map<String, Object> configuration, Optional<String> deprecationWarning) {
        ProcPreconditions.check();
        this.validateGraphName(graphName);
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        Optional<String> maybeRelationshipProperty = Optional.ofNullable(StringUtils.trimToNull((String)relationshipProperty));
        GraphWriteRelationshipConfig config = GraphWriteRelationshipConfig.of(relationshipTypeString, maybeRelationshipProperty, cypherConfig);
        this.validateConfig((CypherMapAccess)cypherConfig, (BaseConfig)config);
        GraphStore graphStore = this.graphStoreFromCatalog(graphName, (BaseConfig)config).graphStore();
        config.validate(graphStore);
        RelationshipType relationshipType = RelationshipType.of((String)relationshipTypeString);
        long relationshipCount = graphStore.relationshipCount(relationshipType);
        TaskProgressTracker progressTracker = new TaskProgressTracker(RelationshipExporter.baseTask((String)"Graph", (long)relationshipCount), this.log, 1, config.jobId(), this.taskRegistryFactory, this.userLogRegistryFactory);
        deprecationWarning.ifPresent(arg_0 -> ((TaskProgressTracker)progressTracker).logWarning(arg_0));
        Result.Builder builder = new Result.Builder(graphName, relationshipTypeString, maybeRelationshipProperty);
        try (ProgressTimer ignored = ProgressTimer.start(builder::withWriteMillis);){
            long relationshipsWritten = (Long)this.runWithExceptionLogging("Writing relationships failed", () -> this.writeRelationshipType(graphStore, config.relationshipProperty(), relationshipType, (ProgressTracker)progressTracker));
            builder.withRelationshipsWritten(relationshipsWritten);
        }
        return Stream.of(builder.build());
    }

    private long writeRelationshipType(GraphStore graphStore, Optional<String> relationshipProperty, RelationshipType relationshipType, ProgressTracker progressTracker) {
        Graph graph = graphStore.getGraph(relationshipType, relationshipProperty);
        RelationshipExporterBuilder builder = this.relationshipExporterBuilder.withIdMappingOperator(arg_0 -> ((Graph)graph).toOriginalNodeId(arg_0)).withGraph(graph).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction)).withProgressTracker(progressTracker);
        if (relationshipProperty.isPresent()) {
            String propertyKey = relationshipProperty.get();
            ValueType propertyType = graphStore.relationshipPropertyType(propertyKey);
            if (propertyType == ValueType.LONG) {
                builder.withRelationPropertyTranslator(property -> Values.longValue((long)((long)property)));
            } else if (propertyType == ValueType.DOUBLE) {
                builder.withRelationPropertyTranslator(Values::doubleValue);
            } else {
                throw new UnsupportedOperationException("Writing non-numeric data is not supported.");
            }
            builder.build().write(relationshipType.name, propertyKey);
        } else {
            builder.build().write(relationshipType.name);
        }
        return graphStore.relationshipCount(relationshipType);
    }

    public static class Result {
        public final long writeMillis;
        public final String graphName;
        public final String relationshipType;
        public final String relationshipProperty;
        public final long relationshipsWritten;
        public final long propertiesWritten;

        Result(long writeMillis, String graphName, String relationshipType, Optional<String> relationshipProperty, long relationshipsWritten) {
            this.writeMillis = writeMillis;
            this.graphName = graphName;
            this.relationshipType = relationshipType;
            this.relationshipProperty = relationshipProperty.orElse(null);
            this.relationshipsWritten = relationshipsWritten;
            this.propertiesWritten = relationshipProperty.isPresent() ? relationshipsWritten : 0L;
        }

        static class Builder {
            private final String graphName;
            private final String relationshipType;
            private final Optional<String> maybeRelationshipProperty;
            private long writeMillis;
            private long relationshipsWritten;

            Builder withWriteMillis(long writeMillis) {
                this.writeMillis = writeMillis;
                return this;
            }

            Builder withRelationshipsWritten(long relationshipsWritten) {
                this.relationshipsWritten = relationshipsWritten;
                return this;
            }

            Builder(String graphName, String relationshipType, Optional<String> maybeRelationshipProperty) {
                this.graphName = graphName;
                this.relationshipType = relationshipType;
                this.maybeRelationshipProperty = maybeRelationshipProperty;
            }

            Result build() {
                return new Result(this.writeMillis, this.graphName, this.relationshipType, this.maybeRelationshipProperty, this.relationshipsWritten);
            }
        }
    }
}

