/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.catalog.GraphDropConfig;
import org.neo4j.gds.config.BaseConfig;

@Generated(from="GraphDropConfig", generator="Immutables")
public final class ImmutableGraphDropConfig
implements GraphDropConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final boolean failIfMissing;
    private final String databaseName;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphDropConfig(boolean failIfMissing, Optional<String> databaseName) {
        this.initShim.failIfMissing(failIfMissing);
        this.databaseName = databaseName.orElse(null);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.failIfMissing = this.initShim.failIfMissing();
        this.initShim = null;
    }

    private ImmutableGraphDropConfig(boolean failIfMissing, String databaseName) {
        this.initShim.failIfMissing(failIfMissing);
        this.databaseName = databaseName;
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.failIfMissing = this.initShim.failIfMissing();
        this.initShim = null;
    }

    private ImmutableGraphDropConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.databaseName = builder.databaseName;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.failIfMissingIsSet()) {
            this.initShim.failIfMissing(builder.failIfMissing);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.failIfMissing = this.initShim.failIfMissing();
        this.initShim = null;
    }

    private ImmutableGraphDropConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, boolean failIfMissing, String databaseName) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.failIfMissing(failIfMissing);
        this.databaseName = databaseName;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.failIfMissing = this.initShim.failIfMissing();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphDropConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return GraphDropConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return GraphDropConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphDropConfig.super.toMap();
    }

    private boolean failIfMissingInitialize() {
        return GraphDropConfig.super.failIfMissing();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public boolean failIfMissing() {
        InitShim shim = this.initShim;
        return shim != null ? shim.failIfMissing() : this.failIfMissing;
    }

    @Override
    public Optional<String> databaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    public final ImmutableGraphDropConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return new ImmutableGraphDropConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.failIfMissing, this.databaseName);
    }

    public final ImmutableGraphDropConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return new ImmutableGraphDropConfig(value, this.sudo, this.logProgress, this.configKeys, this.failIfMissing, this.databaseName);
    }

    public final ImmutableGraphDropConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return new ImmutableGraphDropConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.failIfMissing, this.databaseName);
    }

    public final ImmutableGraphDropConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return new ImmutableGraphDropConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.failIfMissing, this.databaseName);
    }

    public final ImmutableGraphDropConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return new ImmutableGraphDropConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.failIfMissing, this.databaseName);
    }

    public final ImmutableGraphDropConfig withFailIfMissing(boolean value) {
        if (this.failIfMissing == value) {
            return this;
        }
        return new ImmutableGraphDropConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.databaseName);
    }

    public final ImmutableGraphDropConfig withDatabaseName(String value) {
        String newValue = value;
        if (Objects.equals(this.databaseName, newValue)) {
            return this;
        }
        return new ImmutableGraphDropConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.failIfMissing, newValue);
    }

    public final ImmutableGraphDropConfig withDatabaseName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.databaseName, value)) {
            return this;
        }
        return new ImmutableGraphDropConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.failIfMissing, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphDropConfig && this.equalTo((ImmutableGraphDropConfig)another);
    }

    private boolean equalTo(ImmutableGraphDropConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.failIfMissing == another.failIfMissing && Objects.equals(this.databaseName, another.databaseName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + Boolean.hashCode(this.failIfMissing);
        h += (h << 5) + Objects.hashCode(this.databaseName);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphDropConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 16) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("failIfMissing=").append(this.failIfMissing);
        if (this.databaseName != null) {
            builder.append(", ");
            builder.append("databaseName=").append(this.databaseName);
        }
        return builder.append("}").toString();
    }

    public static GraphDropConfig of(boolean failIfMissing, Optional<String> databaseName) {
        return new ImmutableGraphDropConfig(failIfMissing, databaseName);
    }

    public static GraphDropConfig of(boolean failIfMissing, String databaseName) {
        return new ImmutableGraphDropConfig(failIfMissing, databaseName);
    }

    public static GraphDropConfig copyOf(GraphDropConfig instance) {
        if (instance instanceof ImmutableGraphDropConfig) {
            return (ImmutableGraphDropConfig)instance;
        }
        return ImmutableGraphDropConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphDropConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_FAIL_IF_MISSING = 4L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private boolean failIfMissing;
        private String databaseName;

        private Builder() {
        }

        public final Builder from(GraphDropConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GraphDropConfig instance;
            if (object instanceof GraphDropConfig) {
                instance = (GraphDropConfig)object;
                this.failIfMissing(instance.failIfMissing());
                Optional<String> databaseNameOptional = instance.databaseName();
                if (databaseNameOptional.isPresent()) {
                    this.databaseName(databaseNameOptional);
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder failIfMissing(boolean failIfMissing) {
            this.failIfMissing = failIfMissing;
            this.optBits |= 4L;
            return this;
        }

        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Builder databaseName(Optional<String> databaseName) {
            this.databaseName = databaseName.orElse(null);
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.failIfMissing = false;
            this.databaseName = null;
            return this;
        }

        public GraphDropConfig build() {
            return new ImmutableGraphDropConfig(this);
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean failIfMissingIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Generated(from="GraphDropConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte failIfMissingBuildStage = 0;
        private boolean failIfMissing;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphDropConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableGraphDropConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphDropConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphDropConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        boolean failIfMissing() {
            if (this.failIfMissingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.failIfMissingBuildStage == 0) {
                this.failIfMissingBuildStage = (byte)-1;
                this.failIfMissing = ImmutableGraphDropConfig.this.failIfMissingInitialize();
                this.failIfMissingBuildStage = 1;
            }
            return this.failIfMissing;
        }

        void failIfMissing(boolean failIfMissing) {
            this.failIfMissing = failIfMissing;
            this.failIfMissingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.failIfMissingBuildStage == -1) {
                attributes.add("failIfMissing");
            }
            return "Cannot build GraphDropConfig, attribute initializers form cycle " + attributes;
        }
    }
}

