/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.catalog.GraphDropNodePropertiesConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;

@Generated(from="GraphDropNodePropertiesConfig", generator="Immutables")
public final class ImmutableGraphDropNodePropertiesConfig
implements GraphDropNodePropertiesConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final String graphName;
    private final List<String> nodeProperties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphDropNodePropertiesConfig(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> nodeProperties) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName.orElse(null);
        this.nodeProperties = ImmutableGraphDropNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphDropNodePropertiesConfig.createSafeList(nodeProperties, true, false));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.initShim = null;
    }

    private ImmutableGraphDropNodePropertiesConfig(int concurrency, int minBatchSize, String graphName, Iterable<String> nodeProperties) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.nodeProperties = ImmutableGraphDropNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphDropNodePropertiesConfig.createSafeList(nodeProperties, true, false));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.initShim = null;
    }

    private ImmutableGraphDropNodePropertiesConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        List<Object> list = this.nodeProperties = builder.nodeProperties == null ? Collections.emptyList() : ImmutableGraphDropNodePropertiesConfig.createUnmodifiableList(true, builder.nodeProperties);
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.initShim = null;
    }

    private ImmutableGraphDropNodePropertiesConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, String graphName, List<String> nodeProperties) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.nodeProperties = nodeProperties;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphDropNodePropertiesConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return GraphDropNodePropertiesConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return GraphDropNodePropertiesConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphDropNodePropertiesConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return GraphDropNodePropertiesConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return GraphDropNodePropertiesConfig.super.minBatchSize();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    @Override
    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    @Override
    public List<String> nodeProperties() {
        return this.nodeProperties;
    }

    public final ImmutableGraphDropNodePropertiesConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.graphName, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.graphName, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, value, this.nodeProperties));
    }

    public final ImmutableGraphDropNodePropertiesConfig withNodeProperties(String ... elements) {
        List<String> newValue = ImmutableGraphDropNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphDropNodePropertiesConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue));
    }

    public final ImmutableGraphDropNodePropertiesConfig withNodeProperties(Iterable<String> elements) {
        if (this.nodeProperties == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphDropNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphDropNodePropertiesConfig.createSafeList(elements, true, false));
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphDropNodePropertiesConfig && this.equalTo((ImmutableGraphDropNodePropertiesConfig)another);
    }

    private boolean equalTo(ImmutableGraphDropNodePropertiesConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && Objects.equals(this.graphName, another.graphName) && this.nodeProperties.equals(another.nodeProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.nodeProperties.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphDropNodePropertiesConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 30) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("nodeProperties=").append(this.nodeProperties);
        return builder.append("}").toString();
    }

    public static GraphDropNodePropertiesConfig of(int concurrency, int minBatchSize, Optional<String> graphName, List<String> nodeProperties) {
        return ImmutableGraphDropNodePropertiesConfig.of(concurrency, minBatchSize, graphName, nodeProperties);
    }

    public static GraphDropNodePropertiesConfig of(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> nodeProperties) {
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(concurrency, minBatchSize, graphName, nodeProperties));
    }

    public static GraphDropNodePropertiesConfig of(int concurrency, int minBatchSize, String graphName, Iterable<String> nodeProperties) {
        return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(concurrency, minBatchSize, graphName, nodeProperties));
    }

    private static ImmutableGraphDropNodePropertiesConfig validate(ImmutableGraphDropNodePropertiesConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static GraphDropNodePropertiesConfig copyOf(GraphDropNodePropertiesConfig instance) {
        if (instance instanceof ImmutableGraphDropNodePropertiesConfig) {
            return (ImmutableGraphDropNodePropertiesConfig)instance;
        }
        return ImmutableGraphDropNodePropertiesConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphDropNodePropertiesConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private String graphName;
        private List<String> nodeProperties = null;

        private Builder() {
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphDropNodePropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConcurrencyConfig instance;
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof GraphDropNodePropertiesConfig) {
                instance = (GraphDropNodePropertiesConfig)object;
                Optional<String> graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeProperties(instance.nodeProperties());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addNodeProperty(String element) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            return this;
        }

        public final Builder addNodeProperties(String ... elements) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            }
            return this;
        }

        public final Builder nodeProperties(Iterable<String> elements) {
            this.nodeProperties = new ArrayList<String>();
            return this.addAllNodeProperties(elements);
        }

        public final Builder addAllNodeProperties(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeProperties element");
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            }
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.graphName = null;
            if (this.nodeProperties != null) {
                this.nodeProperties.clear();
            }
            return this;
        }

        public GraphDropNodePropertiesConfig build() {
            return ImmutableGraphDropNodePropertiesConfig.validate(new ImmutableGraphDropNodePropertiesConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    @Generated(from="GraphDropNodePropertiesConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphDropNodePropertiesConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableGraphDropNodePropertiesConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphDropNodePropertiesConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphDropNodePropertiesConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableGraphDropNodePropertiesConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableGraphDropNodePropertiesConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            return "Cannot build GraphDropNodePropertiesConfig, attribute initializers form cycle " + attributes;
        }
    }
}

