/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.catalog.GraphStoreToCsvEstimationConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.io.GraphStoreExporterBaseConfig;
import org.neo4j.gds.core.io.file.GraphStoreToFileExporterConfig;

@Generated(from="GraphStoreToCsvEstimationConfig", generator="Immutables")
public final class ImmutableGraphStoreToCsvEstimationConfig
implements GraphStoreToCsvEstimationConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final boolean includeMetaData;
    private final String defaultRelationshipType;
    private final int writeConcurrency;
    private final int batchSize;
    private final PropertyMappings additionalNodeProperties;
    private final String username;
    private final String exportName;
    private final double samplingFactor;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphStoreToCsvEstimationConfig(boolean includeMetaData, String defaultRelationshipType, int writeConcurrency, int batchSize, String username, String exportName, double samplingFactor) {
        this.initShim.includeMetaData(includeMetaData);
        this.initShim.defaultRelationshipType(Objects.requireNonNull(defaultRelationshipType, "defaultRelationshipType"));
        this.initShim.writeConcurrency(writeConcurrency);
        this.initShim.batchSize(batchSize);
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.exportName = Objects.requireNonNull(exportName, "exportName");
        this.initShim.samplingFactor(samplingFactor);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.includeMetaData = this.initShim.includeMetaData();
        this.defaultRelationshipType = this.initShim.defaultRelationshipType();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.batchSize = this.initShim.batchSize();
        this.additionalNodeProperties = this.initShim.additionalNodeProperties();
        this.username = this.initShim.username();
        this.samplingFactor = this.initShim.samplingFactor();
        this.initShim = null;
    }

    private ImmutableGraphStoreToCsvEstimationConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.exportName = builder.exportName;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.includeMetaDataIsSet()) {
            this.initShim.includeMetaData(builder.includeMetaData);
        }
        if (builder.defaultRelationshipType != null) {
            this.initShim.defaultRelationshipType(builder.defaultRelationshipType);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        if (builder.additionalNodeProperties != null) {
            this.initShim.additionalNodeProperties(builder.additionalNodeProperties);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.samplingFactorIsSet()) {
            this.initShim.samplingFactor(builder.samplingFactor);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.includeMetaData = this.initShim.includeMetaData();
        this.defaultRelationshipType = this.initShim.defaultRelationshipType();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.batchSize = this.initShim.batchSize();
        this.additionalNodeProperties = this.initShim.additionalNodeProperties();
        this.username = this.initShim.username();
        this.samplingFactor = this.initShim.samplingFactor();
        this.initShim = null;
    }

    private ImmutableGraphStoreToCsvEstimationConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, boolean includeMetaData, String defaultRelationshipType, int writeConcurrency, int batchSize, PropertyMappings additionalNodeProperties, String username, String exportName, double samplingFactor) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.includeMetaData(includeMetaData);
        this.initShim.defaultRelationshipType(defaultRelationshipType);
        this.initShim.writeConcurrency(writeConcurrency);
        this.initShim.batchSize(batchSize);
        this.initShim.additionalNodeProperties(additionalNodeProperties);
        this.initShim.username(username);
        this.exportName = exportName;
        this.initShim.samplingFactor(samplingFactor);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.includeMetaData = this.initShim.includeMetaData();
        this.defaultRelationshipType = this.initShim.defaultRelationshipType();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.batchSize = this.initShim.batchSize();
        this.additionalNodeProperties = this.initShim.additionalNodeProperties();
        this.username = this.initShim.username();
        this.samplingFactor = this.initShim.samplingFactor();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphStoreToCsvEstimationConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return GraphStoreToCsvEstimationConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return GraphStoreToCsvEstimationConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphStoreToCsvEstimationConfig.super.toMap();
    }

    private boolean includeMetaDataInitialize() {
        return GraphStoreToCsvEstimationConfig.super.includeMetaData();
    }

    private String defaultRelationshipTypeInitialize() {
        return GraphStoreToCsvEstimationConfig.super.defaultRelationshipType();
    }

    private int writeConcurrencyInitialize() {
        return GraphStoreToCsvEstimationConfig.super.writeConcurrency();
    }

    private int batchSizeInitialize() {
        return GraphStoreToCsvEstimationConfig.super.batchSize();
    }

    private PropertyMappings additionalNodePropertiesInitialize() {
        return GraphStoreToCsvEstimationConfig.super.additionalNodeProperties();
    }

    private String usernameInitialize() {
        return GraphStoreToCsvEstimationConfig.super.username();
    }

    private double samplingFactorInitialize() {
        return GraphStoreToCsvEstimationConfig.super.samplingFactor();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public boolean includeMetaData() {
        InitShim shim = this.initShim;
        return shim != null ? shim.includeMetaData() : this.includeMetaData;
    }

    public String defaultRelationshipType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultRelationshipType() : this.defaultRelationshipType;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    public PropertyMappings additionalNodeProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.additionalNodeProperties() : this.additionalNodeProperties;
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public String exportName() {
        return this.exportName;
    }

    @Override
    public double samplingFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.samplingFactor() : this.samplingFactor;
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(value, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withIncludeMetaData(boolean value) {
        if (this.includeMetaData == value) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withDefaultRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "defaultRelationshipType");
        if (this.defaultRelationshipType.equals(newValue)) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, newValue, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, value, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, value, this.additionalNodeProperties, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withAdditionalNodeProperties(PropertyMappings value) {
        if (this.additionalNodeProperties == value) {
            return this;
        }
        PropertyMappings newValue = Objects.requireNonNull(value, "additionalNodeProperties");
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, newValue, this.username, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, newValue, this.exportName, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withExportName(String value) {
        String newValue = Objects.requireNonNull(value, "exportName");
        if (this.exportName.equals(newValue)) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, newValue, this.samplingFactor);
    }

    public final ImmutableGraphStoreToCsvEstimationConfig withSamplingFactor(double value) {
        if (Double.doubleToLongBits(this.samplingFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGraphStoreToCsvEstimationConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.includeMetaData, this.defaultRelationshipType, this.writeConcurrency, this.batchSize, this.additionalNodeProperties, this.username, this.exportName, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphStoreToCsvEstimationConfig && this.equalTo((ImmutableGraphStoreToCsvEstimationConfig)another);
    }

    private boolean equalTo(ImmutableGraphStoreToCsvEstimationConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.includeMetaData == another.includeMetaData && this.defaultRelationshipType.equals(another.defaultRelationshipType) && this.writeConcurrency == another.writeConcurrency && this.batchSize == another.batchSize && this.additionalNodeProperties.equals(another.additionalNodeProperties) && this.username.equals(another.username) && this.exportName.equals(another.exportName) && Double.doubleToLongBits(this.samplingFactor) == Double.doubleToLongBits(another.samplingFactor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + Boolean.hashCode(this.includeMetaData);
        h += (h << 5) + this.defaultRelationshipType.hashCode();
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.batchSize;
        h += (h << 5) + this.additionalNodeProperties.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.exportName.hashCode();
        h += (h << 5) + Double.hashCode(this.samplingFactor);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphStoreToCsvEstimationConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 32) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("includeMetaData=").append(this.includeMetaData);
        builder.append(", ");
        builder.append("defaultRelationshipType=").append(this.defaultRelationshipType);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("batchSize=").append(this.batchSize);
        builder.append(", ");
        builder.append("additionalNodeProperties=").append(this.additionalNodeProperties);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("exportName=").append(this.exportName);
        builder.append(", ");
        builder.append("samplingFactor=").append(this.samplingFactor);
        return builder.append("}").toString();
    }

    public static GraphStoreToCsvEstimationConfig of(boolean includeMetaData, String defaultRelationshipType, int writeConcurrency, int batchSize, String username, String exportName, double samplingFactor) {
        return new ImmutableGraphStoreToCsvEstimationConfig(includeMetaData, defaultRelationshipType, writeConcurrency, batchSize, username, exportName, samplingFactor);
    }

    public static GraphStoreToCsvEstimationConfig copyOf(GraphStoreToCsvEstimationConfig instance) {
        if (instance instanceof ImmutableGraphStoreToCsvEstimationConfig) {
            return (ImmutableGraphStoreToCsvEstimationConfig)instance;
        }
        return ImmutableGraphStoreToCsvEstimationConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphStoreToCsvEstimationConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EXPORT_NAME = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_INCLUDE_META_DATA = 4L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 8L;
        private static final long OPT_BIT_BATCH_SIZE = 16L;
        private static final long OPT_BIT_SAMPLING_FACTOR = 32L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private boolean includeMetaData;
        private String defaultRelationshipType;
        private int writeConcurrency;
        private int batchSize;
        private PropertyMappings additionalNodeProperties;
        private String username;
        private String exportName;
        private double samplingFactor;

        private Builder() {
        }

        public final Builder from(GraphStoreExporterBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphStoreToFileExporterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphStoreToCsvEstimationConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            if (object instanceof GraphStoreExporterBaseConfig) {
                instance = (GraphStoreExporterBaseConfig)object;
                this.includeMetaData(instance.includeMetaData());
                this.additionalNodeProperties(instance.additionalNodeProperties());
                this.writeConcurrency(instance.writeConcurrency());
                this.batchSize(instance.batchSize());
                this.defaultRelationshipType(instance.defaultRelationshipType());
            }
            if (object instanceof GraphStoreToFileExporterConfig) {
                instance = (GraphStoreToFileExporterConfig)object;
                this.exportName(instance.exportName());
                this.username(instance.username());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof GraphStoreToCsvEstimationConfig) {
                instance = (GraphStoreToCsvEstimationConfig)object;
                this.samplingFactor(instance.samplingFactor());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder includeMetaData(boolean includeMetaData) {
            this.includeMetaData = includeMetaData;
            this.optBits |= 4L;
            return this;
        }

        public final Builder defaultRelationshipType(String defaultRelationshipType) {
            this.defaultRelationshipType = Objects.requireNonNull(defaultRelationshipType, "defaultRelationshipType");
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 8L;
            return this;
        }

        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder additionalNodeProperties(PropertyMappings additionalNodeProperties) {
            this.additionalNodeProperties = Objects.requireNonNull(additionalNodeProperties, "additionalNodeProperties");
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder exportName(String exportName) {
            this.exportName = Objects.requireNonNull(exportName, "exportName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder samplingFactor(double samplingFactor) {
            this.samplingFactor = samplingFactor;
            this.optBits |= 0x20L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.includeMetaData = false;
            this.defaultRelationshipType = null;
            this.writeConcurrency = 0;
            this.batchSize = 0;
            this.additionalNodeProperties = null;
            this.username = null;
            this.exportName = null;
            this.samplingFactor = 0.0;
            return this;
        }

        public GraphStoreToCsvEstimationConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphStoreToCsvEstimationConfig(this);
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean includeMetaDataIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean samplingFactorIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("exportName");
            }
            return "Cannot build GraphStoreToCsvEstimationConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphStoreToCsvEstimationConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte includeMetaDataBuildStage = 0;
        private boolean includeMetaData;
        private byte defaultRelationshipTypeBuildStage = 0;
        private String defaultRelationshipType;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;
        private byte batchSizeBuildStage = 0;
        private int batchSize;
        private byte additionalNodePropertiesBuildStage = 0;
        private PropertyMappings additionalNodeProperties;
        private byte usernameBuildStage = 0;
        private String username;
        private byte samplingFactorBuildStage = 0;
        private double samplingFactor;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphStoreToCsvEstimationConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableGraphStoreToCsvEstimationConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphStoreToCsvEstimationConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphStoreToCsvEstimationConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        boolean includeMetaData() {
            if (this.includeMetaDataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.includeMetaDataBuildStage == 0) {
                this.includeMetaDataBuildStage = (byte)-1;
                this.includeMetaData = ImmutableGraphStoreToCsvEstimationConfig.this.includeMetaDataInitialize();
                this.includeMetaDataBuildStage = 1;
            }
            return this.includeMetaData;
        }

        void includeMetaData(boolean includeMetaData) {
            this.includeMetaData = includeMetaData;
            this.includeMetaDataBuildStage = 1;
        }

        String defaultRelationshipType() {
            if (this.defaultRelationshipTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultRelationshipTypeBuildStage == 0) {
                this.defaultRelationshipTypeBuildStage = (byte)-1;
                this.defaultRelationshipType = Objects.requireNonNull(ImmutableGraphStoreToCsvEstimationConfig.this.defaultRelationshipTypeInitialize(), "defaultRelationshipType");
                this.defaultRelationshipTypeBuildStage = 1;
            }
            return this.defaultRelationshipType;
        }

        void defaultRelationshipType(String defaultRelationshipType) {
            this.defaultRelationshipType = defaultRelationshipType;
            this.defaultRelationshipTypeBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableGraphStoreToCsvEstimationConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableGraphStoreToCsvEstimationConfig.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        PropertyMappings additionalNodeProperties() {
            if (this.additionalNodePropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.additionalNodePropertiesBuildStage == 0) {
                this.additionalNodePropertiesBuildStage = (byte)-1;
                this.additionalNodeProperties = Objects.requireNonNull(ImmutableGraphStoreToCsvEstimationConfig.this.additionalNodePropertiesInitialize(), "additionalNodeProperties");
                this.additionalNodePropertiesBuildStage = 1;
            }
            return this.additionalNodeProperties;
        }

        void additionalNodeProperties(PropertyMappings additionalNodeProperties) {
            this.additionalNodeProperties = additionalNodeProperties;
            this.additionalNodePropertiesBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableGraphStoreToCsvEstimationConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        double samplingFactor() {
            if (this.samplingFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.samplingFactorBuildStage == 0) {
                this.samplingFactorBuildStage = (byte)-1;
                this.samplingFactor = ImmutableGraphStoreToCsvEstimationConfig.this.samplingFactorInitialize();
                this.samplingFactorBuildStage = 1;
            }
            return this.samplingFactor;
        }

        void samplingFactor(double samplingFactor) {
            this.samplingFactor = samplingFactor;
            this.samplingFactorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.includeMetaDataBuildStage == -1) {
                attributes.add("includeMetaData");
            }
            if (this.defaultRelationshipTypeBuildStage == -1) {
                attributes.add("defaultRelationshipType");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            if (this.additionalNodePropertiesBuildStage == -1) {
                attributes.add("additionalNodeProperties");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.samplingFactorBuildStage == -1) {
                attributes.add("samplingFactor");
            }
            return "Cannot build GraphStoreToCsvEstimationConfig, attribute initializers form cycle " + attributes;
        }
    }
}

