/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import org.neo4j.gds.result.AbstractResultBuilder;

public final class MutateLabelResult {
    public final long mutateMillis;
    public final String graphName;
    public final String nodeLabel;
    public final long nodeLabelsWritten;
    public final long nodeCount;
    public final Map<String, Object> configuration;

    private MutateLabelResult(long mutateMillis, String graphName, String nodeLabel, long nodeLabelsWritten, long nodeCount, Map<String, Object> configuration) {
        this.mutateMillis = mutateMillis;
        this.graphName = graphName;
        this.nodeLabel = nodeLabel;
        this.nodeLabelsWritten = nodeLabelsWritten;
        this.nodeCount = nodeCount;
        this.configuration = configuration;
    }

    public static Builder builder(String graphName, String nodeLabel) {
        return new Builder(graphName, nodeLabel);
    }

    public static class Builder
    extends AbstractResultBuilder<MutateLabelResult> {
        private long nodeLabelsWritten;
        private Map<String, Object> configuration;
        private final String graphName;
        private final String nodeLabel;

        public Builder(String graphName, String nodeLabel) {
            this.graphName = graphName;
            this.nodeLabel = nodeLabel;
        }

        Builder withNodeLabelsWritten(long propertiesWritten) {
            this.nodeLabelsWritten = propertiesWritten;
            return this;
        }

        Builder withConfig(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public MutateLabelResult build() {
            return new MutateLabelResult(this.mutateMillis, this.graphName, this.nodeLabel, this.nodeLabelsWritten, this.nodeCount, this.configuration);
        }
    }
}

