/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.Map;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.filter.expression.Expression;
import org.neo4j.gds.beta.filter.expression.ExpressionParser;
import org.neo4j.gds.beta.filter.expression.SemanticErrors;
import org.neo4j.gds.beta.filter.expression.ValidationContext;
import org.opencypher.v9_0.parser.javacc.ParseException;

final class NodeFilterParser {
    private NodeFilterParser() {
    }

    static Expression parseAndValidate(GraphStore graphStore, String nodeFilter) throws IllegalArgumentException {
        try {
            ValidationContext validationContext = ValidationContext.forNodes((GraphStore)graphStore);
            Expression filter = ExpressionParser.parse((String)(nodeFilter.equals("*") ? "true" : nodeFilter), (Map)validationContext.availableProperties());
            filter.validate(validationContext).validate();
            return filter;
        }
        catch (SemanticErrors | ParseException e) {
            throw new IllegalArgumentException("Invalid `nodeFilter` expression.", e);
        }
    }
}

