/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public final class UserInputAsStringOrListOfString {
    private UserInputAsStringOrListOfString() {
    }

    public static List<String> parse(Object userInput, String configurationKey) {
        if (userInput instanceof Iterable) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object item : (Iterable)userInput) {
                result.add(UserInputAsStringOrListOfString.parseOne(item, configurationKey));
            }
            return result;
        }
        return List.of(UserInputAsStringOrListOfString.parseOne(userInput, configurationKey));
    }

    private static String parseOne(Object userInput, String configurationKey) {
        if (userInput instanceof String) {
            return (String)userInput;
        }
        throw UserInputAsStringOrListOfString.illegalArgumentException(userInput, configurationKey);
    }

    private static IllegalArgumentException illegalArgumentException(Object userInput, String configurationKey) {
        String type = UserInputAsStringOrListOfString.typeOf(userInput);
        String message = StringFormatting.formatWithLocale((String)"Type mismatch for %s: expected List<String> or String, but found %s", (Object[])new Object[]{configurationKey, type});
        return new IllegalArgumentException(message);
    }

    private static String typeOf(Object userInput) {
        if (userInput instanceof Number) {
            return "number";
        }
        if (userInput instanceof Boolean) {
            return "boolean";
        }
        if (userInput instanceof Node) {
            return "node";
        }
        if (userInput instanceof Relationship) {
            return "relationship";
        }
        if (userInput instanceof Path) {
            return "path";
        }
        if (userInput instanceof Map) {
            return "map";
        }
        if (userInput instanceof List) {
            return "list";
        }
        throw new AssertionError((Object)"Developer error, this should not happen");
    }
}

