/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.catalog.UserInputAsStringOrListOfString;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public interface GraphExportNodePropertiesConfig
extends BaseConfig,
ConcurrencyConfig {
    @Configuration.Parameter
    public Optional<String> graphName();

    @Configuration.Parameter
    @Configuration.ConvertWith(method="org.neo4j.gds.config.GraphExportNodePropertiesConfig#parseNodeProperties")
    public List<String> nodeProperties();

    public static List<String> parseNodeProperties(Object userInput) {
        return UserInputAsStringOrListOfString.parse(userInput, "nodeProperties");
    }

    @Configuration.Parameter
    @Value.Default
    @Configuration.ConvertWith(method="org.neo4j.gds.config.GraphExportNodePropertiesConfig#parseNodeLabels")
    default public List<String> nodeLabels() {
        return Collections.singletonList("*");
    }

    public static List<String> parseNodeLabels(Object userInput) {
        return UserInputAsStringOrListOfString.parse(userInput, "nodeLabels");
    }

    @Configuration.Ignore
    default public Collection<NodeLabel> nodeLabelIdentifiers(GraphStore graphStore) {
        return this.nodeLabels().contains("*") ? graphStore.nodeLabels() : (Collection)this.nodeLabels().stream().map(NodeLabel::of).collect(Collectors.toList());
    }

    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        if (!this.nodeLabels().contains("*")) {
            this.nodeLabelIdentifiers(graphStore).forEach(nodeLabel -> {
                List invalidProperties = this.nodeProperties().stream().filter(nodeProperty -> !graphStore.hasNodeProperty(List.of(nodeLabel), nodeProperty)).collect(Collectors.toList());
                if (!invalidProperties.isEmpty()) {
                    throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expecting all specified node projections to have all given properties defined. Could not find property key(s) %s for label %s. Defined keys: %s.", (Object[])new Object[]{StringJoining.join(invalidProperties), nodeLabel.name, StringJoining.join((Collection)graphStore.nodePropertyKeys(nodeLabel))}));
                }
            });
        } else {
            boolean hasValidLabel = this.nodeLabelIdentifiers(graphStore).stream().anyMatch(nodeLabel -> graphStore.nodePropertyKeys(List.of(nodeLabel)).containsAll(this.nodeProperties()));
            if (!hasValidLabel) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expecting at least one node projection to contain property key(s) %s.", (Object[])new Object[]{StringJoining.join(this.nodeProperties())}));
            }
        }
    }

    @Configuration.Ignore
    default public Collection<NodeLabel> validNodeLabels(GraphStore graphStore) {
        Collection filteredNodeLabels = this.nodeLabels().contains("*") ? (Collection)this.nodeLabelIdentifiers(graphStore).stream().filter(nodeLabel -> graphStore.nodePropertyKeys(nodeLabel).containsAll(this.nodeProperties())).collect(Collectors.toList()) : this.nodeLabelIdentifiers(graphStore);
        return filteredNodeLabels;
    }
}

