/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphWriteRelationshipConfigImpl;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@ValueClass
@Configuration
public interface GraphWriteRelationshipConfig
extends AlgoBaseConfig,
WriteConfig {
    @Configuration.Parameter
    public String relationshipType();

    @Configuration.Parameter
    public Optional<String> relationshipProperty();

    public static GraphWriteRelationshipConfig of(String relationshipType, Optional<String> relationshipProperty, CypherMapWrapper config) {
        return new GraphWriteRelationshipConfigImpl(relationshipType, relationshipProperty, (CypherMapAccess)config);
    }

    @Configuration.Ignore
    default public void validate(GraphStore graphStore) {
        if (!graphStore.hasRelationshipType(RelationshipType.of((String)this.relationshipType()))) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Relationship type `%s` not found. Available types: %s", (Object[])new Object[]{this.relationshipType(), StringJoining.join((Collection)graphStore.relationshipTypes().stream().map(ElementIdentifier::name).collect(Collectors.toSet()))}));
        }
        this.relationshipProperty().ifPresent(relProperty -> {
            Set availableProperties = graphStore.relationshipPropertyKeys(RelationshipType.of((String)this.relationshipType()));
            if (!availableProperties.contains(relProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Relationship property `%s` not found for relationship type '%s'. Available properties: %s", (Object[])new Object[]{relProperty, this.relationshipType(), StringJoining.join((Collection)availableProperties)}));
            }
        });
    }
}

