/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.GraphExportNodePropertiesConfig;
import org.neo4j.gds.config.GraphWriteNodePropertiesConfig;
import org.neo4j.gds.config.WriteConfig;

@Generated(from="GraphWriteNodePropertiesConfig", generator="Immutables")
public final class ImmutableGraphWriteNodePropertiesConfig
implements GraphWriteNodePropertiesConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final String graphName;
    private final List<String> nodeProperties;
    private final List<String> nodeLabels;
    private final int writeConcurrency;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphWriteNodePropertiesConfig(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> nodeProperties, Iterable<String> nodeLabels, int writeConcurrency) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName.orElse(null);
        this.nodeProperties = ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(nodeProperties, true, false));
        this.initShim.nodeLabels(ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.writeConcurrency(writeConcurrency);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.nodeLabels = this.initShim.nodeLabels();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableGraphWriteNodePropertiesConfig(int concurrency, int minBatchSize, String graphName, Iterable<String> nodeProperties, Iterable<String> nodeLabels, int writeConcurrency) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.nodeProperties = ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(nodeProperties, true, false));
        this.initShim.nodeLabels(ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.writeConcurrency(writeConcurrency);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.nodeLabels = this.initShim.nodeLabels();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableGraphWriteNodePropertiesConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.graphName = builder.graphName;
        List<Object> list = this.nodeProperties = builder.nodeProperties == null ? Collections.emptyList() : ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(true, builder.nodeProperties);
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.nodeLabels = this.initShim.nodeLabels();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableGraphWriteNodePropertiesConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, String graphName, List<String> nodeProperties, List<String> nodeLabels, int writeConcurrency) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.nodeProperties = nodeProperties;
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.writeConcurrency(writeConcurrency);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.nodeLabels = this.initShim.nodeLabels();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return GraphWriteNodePropertiesConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return GraphWriteNodePropertiesConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return GraphWriteNodePropertiesConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphWriteNodePropertiesConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return GraphWriteNodePropertiesConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return GraphWriteNodePropertiesConfig.super.minBatchSize();
    }

    private List<String> nodeLabelsInitialize() {
        return GraphWriteNodePropertiesConfig.super.nodeLabels();
    }

    private int writeConcurrencyInitialize() {
        return GraphWriteNodePropertiesConfig.super.writeConcurrency();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    @Override
    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    @Override
    public List<String> nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public final ImmutableGraphWriteNodePropertiesConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.graphName, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.graphName, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, value, this.nodeProperties, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withNodeProperties(String ... elements) {
        List<String> newValue = ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withNodeProperties(Iterable<String> elements) {
        if (this.nodeProperties == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(elements, true, false));
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, newValue, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(elements, true, false));
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, newValue, this.writeConcurrency));
    }

    public final ImmutableGraphWriteNodePropertiesConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.nodeProperties, this.nodeLabels, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphWriteNodePropertiesConfig && this.equalTo((ImmutableGraphWriteNodePropertiesConfig)another);
    }

    private boolean equalTo(ImmutableGraphWriteNodePropertiesConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && Objects.equals(this.graphName, another.graphName) && this.nodeProperties.equals(another.nodeProperties) && this.nodeLabels.equals(another.nodeLabels) && this.writeConcurrency == another.writeConcurrency;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.nodeProperties.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.writeConcurrency;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphWriteNodePropertiesConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 31) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("nodeProperties=").append(this.nodeProperties);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        return builder.append("}").toString();
    }

    public static GraphWriteNodePropertiesConfig of(int concurrency, int minBatchSize, Optional<String> graphName, List<String> nodeProperties, List<String> nodeLabels, int writeConcurrency) {
        return ImmutableGraphWriteNodePropertiesConfig.of(concurrency, minBatchSize, graphName, nodeProperties, nodeLabels, writeConcurrency);
    }

    public static GraphWriteNodePropertiesConfig of(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> nodeProperties, Iterable<String> nodeLabels, int writeConcurrency) {
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(concurrency, minBatchSize, graphName, nodeProperties, nodeLabels, writeConcurrency));
    }

    public static GraphWriteNodePropertiesConfig of(int concurrency, int minBatchSize, String graphName, Iterable<String> nodeProperties, Iterable<String> nodeLabels, int writeConcurrency) {
        return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(concurrency, minBatchSize, graphName, nodeProperties, nodeLabels, writeConcurrency));
    }

    private static ImmutableGraphWriteNodePropertiesConfig validate(ImmutableGraphWriteNodePropertiesConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateConcurrency();
        return instance;
    }

    public static GraphWriteNodePropertiesConfig copyOf(GraphWriteNodePropertiesConfig instance) {
        if (instance instanceof ImmutableGraphWriteNodePropertiesConfig) {
            return (ImmutableGraphWriteNodePropertiesConfig)instance;
        }
        return ImmutableGraphWriteNodePropertiesConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphWriteNodePropertiesConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_NODE_LABELS = 16L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 32L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private String graphName;
        private List<String> nodeProperties = null;
        private List<String> nodeLabels = null;
        private int writeConcurrency;

        private Builder() {
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphExportNodePropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphWriteNodePropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof GraphExportNodePropertiesConfig) {
                instance = (GraphExportNodePropertiesConfig)object;
                Optional<String> graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllNodeProperties(instance.nodeProperties());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addNodeProperty(String element) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            return this;
        }

        public final Builder addNodeProperties(String ... elements) {
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            }
            return this;
        }

        public final Builder nodeProperties(Iterable<String> elements) {
            this.nodeProperties = new ArrayList<String>();
            return this.addAllNodeProperties(elements);
        }

        public final Builder addAllNodeProperties(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeProperties element");
            if (this.nodeProperties == null) {
                this.nodeProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
            }
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x20L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.graphName = null;
            if (this.nodeProperties != null) {
                this.nodeProperties.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.writeConcurrency = 0;
            return this;
        }

        public GraphWriteNodePropertiesConfig build() {
            return ImmutableGraphWriteNodePropertiesConfig.validate(new ImmutableGraphWriteNodePropertiesConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    @Generated(from="GraphWriteNodePropertiesConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphWriteNodePropertiesConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableGraphWriteNodePropertiesConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphWriteNodePropertiesConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphWriteNodePropertiesConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableGraphWriteNodePropertiesConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableGraphWriteNodePropertiesConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableGraphWriteNodePropertiesConfig.createUnmodifiableList(false, ImmutableGraphWriteNodePropertiesConfig.createSafeList(ImmutableGraphWriteNodePropertiesConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableGraphWriteNodePropertiesConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build GraphWriteNodePropertiesConfig, attribute initializers form cycle " + attributes;
        }
    }
}

