/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphSampleAlgoConfig;
import org.neo4j.gds.config.RandomWalkWithRestartsProcConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;

public final class RandomWalkWithRestartsProcConfigImpl
implements RandomWalkWithRestartsProcConfig {
    private GraphProjectConfig originalConfig;
    private String fromGraphName;
    private GraphSampleAlgoConfig sampleAlgoConfig;
    private String username;
    private String graphName;
    private int readConcurrency;
    private long nodeCount;
    private long relationshipCount;
    private ZonedDateTime creationTime;
    private boolean validateRelationships;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private JobId jobId;

    public RandomWalkWithRestartsProcConfigImpl(@NotNull GraphProjectConfig originalConfig, @NotNull String fromGraphName, @NotNull GraphSampleAlgoConfig sampleAlgoConfig, @NotNull String username, @NotNull String graphName, @NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.originalConfig = (GraphProjectConfig)CypherMapAccess.failOnNull((String)"originalConfig", (Object)originalConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.fromGraphName = (String)CypherMapAccess.failOnNull((String)"fromGraphName", (Object)fromGraphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleAlgoConfig = (GraphSampleAlgoConfig)CypherMapAccess.failOnNull((String)"sampleAlgoConfig", (Object)sampleAlgoConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapAccess.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = GraphProjectConfig.validateName((String)((String)CypherMapAccess.failOnNull((String)"graphName", (Object)graphName)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", RandomWalkWithRestartsProcConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeCount = config.getLong("nodeCount", RandomWalkWithRestartsProcConfig.super.nodeCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.getLong("relationshipCount", RandomWalkWithRestartsProcConfig.super.relationshipCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapAccess.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)RandomWalkWithRestartsProcConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateRelationships = config.getBool("validateRelationships", RandomWalkWithRestartsProcConfig.super.validateRelationships());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", RandomWalkWithRestartsProcConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", RandomWalkWithRestartsProcConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)RandomWalkWithRestartsProcConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    public GraphProjectConfig originalConfig() {
        return this.originalConfig;
    }

    public String fromGraphName() {
        return this.fromGraphName;
    }

    public GraphSampleAlgoConfig sampleAlgoConfig() {
        return this.sampleAlgoConfig;
    }

    public String username() {
        return this.username;
    }

    public String graphName() {
        return this.graphName;
    }

    public int readConcurrency() {
        return this.readConcurrency;
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long relationshipCount() {
        return this.relationshipCount;
    }

    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    public boolean validateRelationships() {
        return this.validateRelationships;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("readConcurrency", "nodeCount", "relationshipCount", "creationTime", "validateRelationships", "username", "sudo", "logProgress", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("readConcurrency", this.readConcurrency());
        map.put("nodeCount", this.nodeCount());
        map.put("relationshipCount", this.relationshipCount());
        map.put("creationTime", this.creationTime());
        map.put("validateRelationships", this.validateRelationships());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        return map;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private GraphProjectConfig originalConfig;
        @NotNull
        private String fromGraphName;
        @NotNull
        private GraphSampleAlgoConfig sampleAlgoConfig;
        @NotNull
        private String username;
        @NotNull
        private String graphName;

        public static Builder from(RandomWalkWithRestartsProcConfig baseConfig) {
            Builder builder = new Builder();
            builder.originalConfig(baseConfig.originalConfig());
            builder.fromGraphName(baseConfig.fromGraphName());
            builder.sampleAlgoConfig(baseConfig.sampleAlgoConfig());
            builder.username(baseConfig.username());
            builder.graphName(baseConfig.graphName());
            builder.readConcurrency(baseConfig.readConcurrency());
            builder.nodeCount(baseConfig.nodeCount());
            builder.relationshipCount(baseConfig.relationshipCount());
            builder.creationTime(baseConfig.creationTime());
            builder.validateRelationships(baseConfig.validateRelationships());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.jobId(baseConfig.jobId());
            return builder;
        }

        public Builder originalConfig(GraphProjectConfig originalConfig) {
            this.originalConfig = originalConfig;
            return this;
        }

        public Builder fromGraphName(String fromGraphName) {
            this.fromGraphName = fromGraphName;
            return this;
        }

        public Builder sampleAlgoConfig(GraphSampleAlgoConfig sampleAlgoConfig) {
            this.sampleAlgoConfig = sampleAlgoConfig;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder nodeCount(long nodeCount) {
            this.config.put("nodeCount", nodeCount);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder validateRelationships(boolean validateRelationships) {
            this.config.put("validateRelationships", validateRelationships);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public RandomWalkWithRestartsProcConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new RandomWalkWithRestartsProcConfigImpl(this.originalConfig, this.fromGraphName, this.sampleAlgoConfig, this.username, this.graphName, (CypherMapAccess)config);
        }
    }
}

