/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.model.catalog;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.core.model.Model;

public class ModelCatalogResult {
    public final Map<String, Object> modelInfo;
    public final Map<String, Object> trainConfig;
    public final Map<String, Object> graphSchema;
    public final boolean loaded;
    public final boolean stored;
    public final ZonedDateTime creationTime;
    public final boolean shared;

    public ModelCatalogResult(Model<?, ?, ?> model) {
        this.shared = !model.sharedWith().isEmpty();
        this.modelInfo = Stream.concat(Map.of("modelName", model.name(), "modelType", model.algoType()).entrySet().stream(), model.customInfo().toMap().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.trainConfig = model.trainConfig().toMap();
        this.graphSchema = model.graphSchema().toMapOld();
        this.loaded = model.loaded();
        this.stored = model.stored();
        this.creationTime = model.creationTime();
    }
}

