/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.model.catalog;

import java.util.stream.Stream;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.model.catalog.ModelCatalogProc;
import org.neo4j.gds.model.catalog.ModelCatalogResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ModelDropProc
extends ModelCatalogProc {
    private static final String DESCRIPTION = "Drops a loaded model and frees up the resources it occupies.";

    @Procedure(name="gds.beta.model.drop", mode=Mode.READ)
    @Description(value="Drops a loaded model and frees up the resources it occupies.")
    public Stream<ModelCatalogResult> drop(@Name(value="modelName") String modelName, @Name(value="failIfMissing", defaultValue="true") boolean failIfMissing) {
        this.validateModelName(modelName);
        Model model = failIfMissing ? this.modelCatalog().dropOrThrow(this.username(), modelName) : this.modelCatalog().drop(this.username(), modelName);
        return Stream.ofNullable(model).map(ModelCatalogResult::new);
    }
}

