/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.model.catalog;

import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.model.catalog.ModelCatalogProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ModelExistsProc
extends ModelCatalogProc {
    private static final String DESCRIPTION = "Checks if a given model exists in the model catalog.";

    @Procedure(name="gds.beta.model.exists", mode=Mode.READ)
    @Description(value="Checks if a given model exists in the model catalog.")
    public Stream<ModelExistsResult> exists(@Name(value="modelName") String modelName) {
        this.validateModelName(modelName);
        ModelCatalog modelCatalog = this.modelCatalog();
        return Stream.of(new ModelExistsResult(modelName, Optional.ofNullable(modelCatalog.getUntyped(this.username(), modelName)).map(Model::algoType).orElse("n/a"), modelCatalog.exists(this.username(), modelName)));
    }

    public static class ModelExistsResult {
        public final String modelName;
        public final String modelType;
        public final boolean exists;

        ModelExistsResult(String modelName, String modelType, boolean exists) {
            this.modelName = modelName;
            this.modelType = modelType;
            this.exists = exists;
        }
    }
}

