/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.model.catalog;

import java.util.Collection;
import java.util.stream.Stream;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.model.catalog.ModelCatalogProc;
import org.neo4j.gds.model.catalog.ModelCatalogResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ModelListProc
extends ModelCatalogProc {
    private static final String DESCRIPTION = "Lists all models contained in the model catalog.";

    @Procedure(name="gds.beta.model.list", mode=Mode.READ)
    @Description(value="Lists all models contained in the model catalog.")
    public Stream<ModelCatalogResult> list(@Name(value="modelName", defaultValue="__NO_VALUE") String modelName) {
        ModelCatalog modelCatalog = this.modelCatalog();
        if (modelName == null || modelName.equals("__NO_VALUE")) {
            Collection models = modelCatalog.list(this.username());
            return models.stream().map(ModelCatalogResult::new);
        }
        this.validateModelName(modelName);
        Model model = modelCatalog.getUntyped(this.username(), modelName);
        return model == null ? Stream.empty() : Stream.of(new ModelCatalogResult(model));
    }
}

