/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityFactory;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.validation.BeforeLoadValidation;
import org.neo4j.gds.executor.validation.GraphProjectConfigValidations;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;

final class BetweennessCentralityProc {
    static final String BETWEENNESS_DESCRIPTION = "Betweenness centrality measures the relative information flow that passes through a node.";

    private BetweennessCentralityProc() {
    }

    static <CONFIG extends BetweennessCentralityBaseConfig> NodeProperties nodeProperties(ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, CONFIG> computeResult) {
        return ((HugeAtomicDoubleArray)computeResult.result()).asNodeProperties();
    }

    static <CONFIG extends BetweennessCentralityBaseConfig> GraphAlgorithmFactory<BetweennessCentrality, CONFIG> algorithmFactory() {
        return new BetweennessCentralityFactory();
    }

    static <PROC_RESULT, CONFIG extends BetweennessCentralityBaseConfig> AbstractCentralityResultBuilder<PROC_RESULT> resultBuilder(AbstractCentralityResultBuilder<PROC_RESULT> procResultBuilder, ComputationResult<BetweennessCentrality, HugeAtomicDoubleArray, CONFIG> computeResult) {
        if (computeResult.result() != null) {
            HugeAtomicDoubleArray centrality = (HugeAtomicDoubleArray)computeResult.result();
            procResultBuilder.withCentralityFunction(arg_0 -> ((HugeAtomicDoubleArray)((HugeAtomicDoubleArray)computeResult.result())).get(arg_0));
        }
        return procResultBuilder;
    }

    static <CONFIG extends BetweennessCentralityBaseConfig> ValidationConfiguration<CONFIG> getValidationConfig() {
        return new ValidationConfiguration<CONFIG>(){

            public List<BeforeLoadValidation<CONFIG>> beforeLoadValidations() {
                return List.of(new GraphProjectConfigValidations.OrientationValidation());
            }
        };
    }
}

