/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.degree;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityFactory;
import org.neo4j.gds.degree.DegreeCentralityProc;
import org.neo4j.gds.degree.DegreeCentralityWriteConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardWriteResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.degree.write", description="Degree centrality measures the number of incoming and outgoing relationships from a node.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class DegreeCentralityWriteProc
extends WriteProc<DegreeCentrality, DegreeCentrality.DegreeFunction, WriteResult, DegreeCentralityWriteConfig> {
    @Procedure(value="gds.degree.write", mode=Mode.WRITE)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.degree.write.estimate", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodeProperties nodeProperties(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, DegreeCentralityWriteConfig> computationResult) {
        return DegreeCentralityProc.nodeProperties(computationResult);
    }

    protected DegreeCentralityWriteConfig newConfig(String username, CypherMapWrapper config) {
        return DegreeCentralityWriteConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<DegreeCentrality, DegreeCentralityWriteConfig> algorithmFactory() {
        return new DegreeCentralityFactory();
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<DegreeCentrality, DegreeCentrality.DegreeFunction, DegreeCentralityWriteConfig> computeResult, ExecutionContext executionContext) {
        return DegreeCentralityProc.resultBuilder(new WriteResult.Builder(this.callContext, ((DegreeCentralityWriteConfig)computeResult.config()).concurrency()), computeResult);
    }

    public static final class WriteResult
    extends StandardWriteResult {
        public final long nodePropertiesWritten;
        public final Map<String, Object> centralityDistribution;

        WriteResult(long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long postProcessingMillis, long writeMillis, @Nullable Map<String, Object> centralityDistribution, Map<String, Object> config) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, writeMillis, config);
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.centralityDistribution = centralityDistribution;
        }

        static class Builder
        extends AbstractCentralityResultBuilder<WriteResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            protected WriteResult buildResult() {
                return new WriteResult(this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.writeMillis, this.centralityHistogram, this.config.toMap());
            }
        }
    }
}

